/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.curio;

import com.google.common.collect.Multimap;
import elucent.eidolon.common.item.curio.BasicBeltItem;
import elucent.eidolon.registries.Registry;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class GravityBeltItem
extends BasicBeltItem {
    public GravityBeltItem(Item.Properties properties) {
        super(properties);
        NeoForge.EVENT_BUS.addListener(GravityBeltItem::onFall);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (CuriosApi.getCuriosInventory((LivingEntity)event.getEntity()).flatMap(i -> i.findFirstCurio((Item)Registry.GRAVITY_BELT.get())).isPresent()) {
            event.setDistance(event.getDistance() / 4.0f);
        }
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        Multimap<Holder<Attribute>, AttributeModifier> map = super.getAttributeModifiers(slotContext, id, stack);
        map.put((Object)Attributes.GRAVITY, (Object)new AttributeModifier(id, (double)-0.6f, AttributeModifier.Operation.ADD_VALUE));
        return map;
    }
}

