/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.curio;

import elucent.eidolon.common.item.curio.EidolonCurio;
import elucent.eidolon.registries.EidolonDataComponents;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.util.TargetMode;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class AngelSightItem
extends EidolonCurio {
    public AngelSightItem(Item.Properties properties) {
        super(properties);
        NeoForge.EVENT_BUS.addListener(AngelSightItem::addMode);
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return !slotContext.entity().isShiftKeyDown();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        if (pPlayer.isShiftKeyDown() && !pLevel.isClientSide) {
            ItemStack stack = pPlayer.getItemInHand(pUsedHand);
            int mode = (Integer)stack.getOrDefault(EidolonDataComponents.TARGET_MODE, (Object)0);
            mode = (mode + 1) % 3;
            stack.set(EidolonDataComponents.TARGET_MODE, (Object)mode);
            pPlayer.sendSystemMessage((Component)Component.translatable((String)("eidolon.angels_sight.mode." + mode)));
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, level, tooltip, flag);
        String modeTooltip = switch ((Integer)stack.getOrDefault(EidolonDataComponents.TARGET_MODE, (Object)0)) {
            case 1 -> "lore.eidolon.angels_sight.mode.1";
            case 2 -> "lore.eidolon.angels_sight.mode.2";
            default -> "lore.eidolon.angels_sight.mode.3";
        };
        tooltip.add((Component)Component.translatable((String)modeTooltip).withStyle(ChatFormatting.DARK_GRAY));
    }

    @SubscribeEvent
    public static void addMode(EntityJoinLevelEvent event) {
        Projectile projectile;
        Entity entity = event.getEntity();
        if (entity instanceof Projectile && (entity = (projectile = (Projectile)entity).getOwner()) instanceof Player) {
            Player player = (Player)entity;
            CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(inventory -> inventory.findFirstCurio((Item)Registry.ANGELS_SIGHT.get())).ifPresent(ring -> {
                Predicate<Entity> targetMode;
                switch ((Integer)ring.stack().getOrDefault(EidolonDataComponents.TARGET_MODE, (Object)0)) {
                    case 1: {
                        Predicate<Entity> predicate = target -> target instanceof LivingEntity && !(target instanceof Player);
                        break;
                    }
                    case 2: {
                        Predicate<Entity> predicate = target -> target instanceof Enemy;
                        break;
                    }
                    default: {
                        Predicate<Entity> predicate = targetMode = target -> target instanceof LivingEntity;
                    }
                }
                if (projectile instanceof TargetMode) {
                    TargetMode mode = (TargetMode)projectile;
                    mode.eidolonrepraised$setMode(targetMode);
                }
            });
        }
    }
}

