/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import com.mojang.datafixers.util.Pair;
import elucent.eidolon.common.entity.SpellProjectileEntity;
import elucent.eidolon.common.item.IRechargeableWand;
import elucent.eidolon.common.item.ItemBase;
import elucent.eidolon.common.item.SoulfireWandItem;
import elucent.eidolon.compat.CompatHandler;
import elucent.eidolon.compat.apotheosis.Apotheosis;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WandItem
extends ItemBase
implements IRechargeableWand {
    private static final double OFFSET = 1.5;

    public WandItem(Item.Properties properties) {
        super(properties);
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return 20;
    }

    @Override
    public ItemStack recharge(ItemStack stack) {
        stack.setDamageValue(0);
        return stack;
    }

    public InteractionResultHolder<ItemStack> handleCast(Level world, Player entity, InteractionHand hand, @NotNull EntityType<? extends SpellProjectileEntity> spellProjectile, SoundEvent soundEvent) {
        ItemStack stack = entity.getItemInHand(hand);
        if (!world.isClientSide()) {
            Vec3 pos = entity.position().add(entity.getLookAngle().scale(0.5)).add(0.5 * Math.sin(Math.toRadians(225.0f - entity.yHeadRot)), (double)(entity.getBbHeight() * 2.0f / 3.0f), 0.5 * Math.cos(Math.toRadians(225.0f - entity.yHeadRot)));
            Vec3 vel = entity.getEyePosition(0.0f).add(entity.getLookAngle().scale(40.0)).subtract(pos).scale(0.05);
            Pair affixData = CompatHandler.isModLoaded("apotheosis") ? Apotheosis.handleWandAffix(stack) : Pair.of((Object)1, (Object)0);
            int projectileAmount = (Integer)affixData.getFirst();
            int trackingAmount = (Integer)affixData.getSecond();
            for (int i = 0; i < projectileAmount; ++i) {
                SpellProjectileEntity spellProjectileEntity = (SpellProjectileEntity)spellProjectile.create(world);
                if (spellProjectileEntity == null) continue;
                if (trackingAmount > 0) {
                    spellProjectileEntity.isTracking = true;
                    --trackingAmount;
                }
                Vec3 randomized = Vec3.ZERO;
                if (i > 0) {
                    randomized = new Vec3(SoulfireWandItem.random.nextDouble(-1.5, 1.5), SoulfireWandItem.random.nextDouble(-1.5, 1.5), SoulfireWandItem.random.nextDouble(-1.5, 1.5));
                    spellProjectileEntity.noImmunityFrame = true;
                }
                world.addFreshEntity(spellProjectileEntity.shoot(pos.x + randomized.x(), pos.y + randomized.y(), pos.z + randomized.z(), vel.x, vel.y, vel.z, (Entity)entity, stack));
            }
            world.playSound(null, pos.x, pos.y, pos.z, soundEvent, SoundSource.NEUTRAL, 0.75f, SoulfireWandItem.random.nextFloat() * 0.2f + 0.9f);
            stack.hurtAndBreak(1, (LivingEntity)entity, LivingEntity.getSlotForHand((InteractionHand)hand));
            entity.getCooldowns().addCooldown((Item)this, 15);
        }
        if (!entity.swinging) {
            entity.swing(hand);
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

