/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.common.item.model.TopHatModel;
import elucent.eidolon.registries.EidolonMaterials;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopHatItem
extends ArmorItem {
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    String loreTag = null;

    public TopHatItem(Item.Properties builderIn) {
        super(EidolonMaterials.TOP_HAT, ArmorItem.Type.HELMET, builderIn);
    }

    public Item setLore(String tag) {
        this.loreTag = tag;
        return this;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        if (this.loreTag != null) {
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_PURPLE) + String.valueOf(ChatFormatting.ITALIC) + I18n.get((String)this.loreTag, (Object[])new Object[0]))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public TopHatModel getHumanoidArmorModel(@NotNull LivingEntity entity, @NotNull ItemStack itemStack, @NotNull EquipmentSlot armorSlot, @NotNull HumanoidModel _default) {
                float pticks = Minecraft.getInstance().getFrameTimeNs();
                float f = Mth.rotLerp((float)pticks, (float)entity.yBodyRotO, (float)entity.yBodyRot);
                float f1 = Mth.rotLerp((float)pticks, (float)entity.yHeadRotO, (float)entity.yHeadRot);
                float netHeadYaw = f1 - f;
                float netHeadPitch = Mth.lerp((float)pticks, (float)entity.xRotO, (float)entity.getXRot());
                ClientRegistry.TOP_HAT_MODEL.slot = TopHatItem.this.getEquipmentSlot();
                ClientRegistry.TOP_HAT_MODEL.copyFromDefault(_default);
                ClientRegistry.TOP_HAT_MODEL.setupAnim(entity, entity.walkAnimation.position(), entity.walkAnimation.speed(), (float)entity.tickCount + pticks, netHeadYaw, netHeadPitch);
                return ClientRegistry.TOP_HAT_MODEL;
            }
        });
    }

    @Nullable
    public ResourceLocation getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EquipmentSlot slot, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorMaterial.Layer layer, boolean innerModel) {
        return ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"textures/entity/hat.png");
    }
}

