/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.item.ItemBase;
import elucent.eidolon.network.MagicBurstEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.EidolonDataComponents;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.util.ColorUtil;
import elucent.eidolon.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SummoningStaffItem
extends ItemBase {
    public SummoningStaffItem(Item.Properties builderIn) {
        super(builderIn);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 72000;
    }

    public void onUseTick(@NotNull Level pLevel, LivingEntity entity, @NotNull ItemStack stack, int time) {
        HitResult hit;
        if (entity.level().isClientSide && (hit = entity.pick(16.0, 0.0f, false)).getType() != HitResult.Type.MISS) {
            Vec3 pos = hit.getLocation();
            time = 72000 - time;
            float alpha = Mth.clamp((float)((float)time / 40.0f), (float)0.0f, (float)1.0f);
            float a = (float)Math.PI / 180 * (float)(entity.level().getGameTime() % 360L + (long)(12 * time));
            float r = 0.3f + 0.3f * alpha;
            float sa = r * Mth.sin((float)a);
            float ca = r * Mth.cos((float)a);
            if (time == 40) {
                entity.playSound((SoundEvent)SoundEvents.CROSSBOW_QUICK_CHARGE_3.value(), 1.0f, 1.0f);
            }
            Particles.create((ParticleType)EidolonParticles.SMOKE_PARTICLE.get()).randomVelocity(0.025f * alpha, 0.0125f * alpha).setColor(0.12941177f, 0.101960786f, 0.09019608f, 0.125f, 0.039215688f, 0.039215688f, 0.047058824f, 0.0f).setAlpha(0.25f * alpha, 0.0f).randomOffset(0.05f + 0.05f * alpha).setScale(0.25f + 0.25f * alpha, alpha * 0.125f).repeat(entity.level(), pos.x + (double)sa, pos.y, pos.z + (double)ca, 2).repeat(entity.level(), pos.x - (double)sa, pos.y, pos.z - (double)ca, 2);
        }
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int time) {
        if (72000 - time >= 20 && this.hasCharges(stack)) {
            ThrallData thrallData = (ThrallData)stack.get(EidolonDataComponents.THRALLS);
            if (thrallData == null || thrallData.thralls().isEmpty()) {
                return;
            }
            int selected = thrallData.selected();
            CompoundTag tag = thrallData.thralls().get(selected);
            HitResult hit = entity.pick(16.0, 0.0f, false);
            if (hit.getType() != HitResult.Type.MISS) {
                Vec3 pos = hit.getLocation();
                Optional etype = EntityType.by((CompoundTag)tag);
                if (etype.isPresent() && !level.isClientSide) {
                    tag.remove("UUID");
                    EntityType cfr_ignored_0 = (EntityType)etype.get();
                    Optional e = EntityType.create((CompoundTag)tag, (Level)level);
                    if (e.isPresent()) {
                        ((Entity)e.get()).setPos(pos);
                        EntityUtil.enthrall(entity, (LivingEntity)e.get());
                        level.addFreshEntity((Entity)e.get());
                        Networking.sendToNearbyClient(entity.level(), ((Entity)e.get()).blockPosition(), (CustomPacketPayload)new MagicBurstEffectPacket(((Entity)e.get()).getX(), ((Entity)e.get()).getY() + (double)(((Entity)e.get()).getBbHeight() / 2.0f), ((Entity)e.get()).getZ(), ColorUtil.packColor(255, 61, 70, 35), ColorUtil.packColor(255, 36, 24, 41)));
                        level.playSound(null, ((Entity)e.get()).blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.75f, 0.1f);
                    }
                }
                entity.setItemInHand(entity.getUsedItemHand(), entity instanceof Player && ((Player)entity).getAbilities().instabuild ? stack : this.consumeCharge(stack, selected));
                entity.swing(entity.getUsedItemHand());
                entity.stopUsingItem();
            }
        }
    }

    public int getSelected(ItemStack stack) {
        ThrallData thrallData = (ThrallData)stack.get(EidolonDataComponents.THRALLS);
        if (thrallData == null) {
            return 0;
        }
        int selected = thrallData.selected();
        if (selected >= thrallData.thralls().size()) {
            selected = 0;
        }
        return selected;
    }

    public int changeSelection(ItemStack stack, int diff) {
        ThrallData thrallData = (ThrallData)stack.get(EidolonDataComponents.THRALLS);
        if (thrallData == null || thrallData.thralls().isEmpty()) {
            return 0;
        }
        int size = thrallData.thralls().size();
        int selected = (thrallData.selected() + diff) % size;
        if (selected < 0) {
            selected += size;
        }
        ThrallData newData = new ThrallData(thrallData.thralls(), selected);
        stack.set(EidolonDataComponents.THRALLS, (Object)newData);
        return selected;
    }

    public ItemStack addCharges(ItemStack stack, ListTag charges) {
        ThrallData thrallData = (ThrallData)stack.get(EidolonDataComponents.THRALLS);
        if (thrallData == null) {
            thrallData = new ThrallData(new ArrayList<CompoundTag>(), 0);
        }
        List<CompoundTag> thralls = thrallData.thralls();
        while (thralls.size() + charges.size() > 100) {
            charges.removeLast();
        }
        for (int i = 0; i < charges.size(); ++i) {
            thralls.add(charges.getCompound(i));
        }
        stack.set(EidolonDataComponents.THRALLS, (Object)new ThrallData(thralls, thrallData.selected()));
        return stack;
    }

    public void addCharge(ItemStack stack, CompoundTag tag) {
        List<CompoundTag> thralls;
        ThrallData thrallData = (ThrallData)stack.get(EidolonDataComponents.THRALLS);
        if (thrallData == null) {
            thrallData = new ThrallData(new ArrayList<CompoundTag>(), 0);
        }
        if ((thralls = thrallData.thralls()).size() < 100) {
            thralls.add(tag);
        }
        stack.set(EidolonDataComponents.THRALLS, (Object)new ThrallData(thralls, thrallData.selected()));
    }

    public boolean hasCharges(ItemStack stack) {
        ThrallData thrallData = (ThrallData)stack.get(EidolonDataComponents.THRALLS);
        return thrallData != null && !thrallData.thralls().isEmpty();
    }

    public ItemStack consumeCharge(ItemStack stack, int index) {
        int selected;
        ThrallData thrallData = (ThrallData)stack.get(EidolonDataComponents.THRALLS);
        if (thrallData == null) {
            return stack;
        }
        ArrayList<CompoundTag> thralls = new ArrayList<CompoundTag>(thrallData.thralls());
        if (index < thralls.size()) {
            thralls.remove(index);
        }
        if ((selected = thrallData.selected()) >= thralls.size()) {
            selected = 0;
        }
        stack.set(EidolonDataComponents.THRALLS, (Object)new ThrallData(thralls, selected));
        return stack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.hasCharges(stack)) {
            if (player.isShiftKeyDown()) {
                int sel = this.changeSelection(stack, 1);
                ThrallData thrallData = (ThrallData)stack.get(EidolonDataComponents.THRALLS);
                if (thrallData == null || thrallData.thralls().isEmpty()) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                CompoundTag tag = thrallData.thralls().get(sel);
                ResourceLocation id = ResourceLocation.parse((String)tag.getString("id"));
                String summonKey = "entity." + id.getNamespace() + "." + id.getPath();
                player.setItemInHand(hand, stack);
                if (!world.isClientSide) {
                    ((ServerPlayer)player).connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"eidolon.tooltip.active_summon").append((Component)Component.translatable((String)summonKey).withStyle(ChatFormatting.LIGHT_PURPLE))));
                    player.playNotifySound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResultHolder.fail((Object)stack);
            }
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        boolean charge = this.hasCharges(stack);
        int selected = this.getSelected(stack);
        Object summonKey = "eidolon.tooltip.no_selected_summon";
        if (charge) {
            ThrallData thrallData = (ThrallData)stack.get(EidolonDataComponents.THRALLS);
            if (thrallData == null || thrallData.thralls().isEmpty()) {
                return;
            }
            CompoundTag tag = thrallData.thralls().get(selected);
            String ids = tag.getString("id");
            ResourceLocation id = ResourceLocation.parse((String)tag.getString("id"));
            summonKey = "entity." + id.getNamespace() + "." + id.getPath();
        }
        tooltip.add((Component)Component.translatable((String)"eidolon.tooltip.active_summon").append((Component)Component.translatable((String)summonKey).withStyle(charge ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.DARK_PURPLE)));
    }

    public record ThrallData(List<CompoundTag> thralls, int selected) {
        public static final Codec<ThrallData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)CompoundTag.CODEC).fieldOf("thralls").forGetter(ThrallData::thralls), (App)Codec.INT.optionalFieldOf("selected", (Object)0).forGetter(ThrallData::selected)).apply((Applicative)instance, ThrallData::new));

        public ThrallData(List<CompoundTag> thralls) {
            this(thralls, 0);
        }
    }
}

