/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import elucent.eidolon.api.research.Research;
import elucent.eidolon.common.item.ItemBase;
import elucent.eidolon.registries.EidolonDataComponents;
import elucent.eidolon.registries.Researches;
import elucent.eidolon.util.KnowledgeUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ResearchNotesItem
extends ItemBase {
    private static final Random random = new Random();

    public ResearchNotesItem(Item.Properties builderIn) {
        super(builderIn.component(EidolonDataComponents.RESEARCH, (Object)ResearchData.EMPTY));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        ResearchData researchData = (ResearchData)stack.get(EidolonDataComponents.RESEARCH);
        if (researchData == null) {
            return;
        }
        Research r = Researches.find(researchData.research());
        if (r == null) {
            return;
        }
        int done = researchData.stepsDone();
        StringBuilder stars = new StringBuilder();
        stars.append(ChatFormatting.GOLD);
        for (int i = 0; i < r.getStars(); ++i) {
            if (i == done) {
                stars.append(ChatFormatting.GRAY);
            }
            if (i < done) {
                stars.append("\u2605");
                continue;
            }
            stars.append("\u2606");
        }
        tooltip.add((Component)Component.literal((String)stars.toString()));
        boolean known = done >= r.getStars() || KnowledgeUtil.knowsResearch((Player)Minecraft.getInstance().player, r.getRegistryName());
        String name = known ? r.getName() : "???";
        tooltip.add((Component)Component.literal((String)(String.valueOf(known ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY) + String.valueOf(ChatFormatting.ITALIC) + name)));
    }

    public record ResearchData(ResourceLocation research, int stepsDone, long seed) {
        public static final Codec<ResearchData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("research").forGetter(ResearchData::research), (App)Codec.INT.fieldOf("stepsDone").forGetter(ResearchData::stepsDone), (App)Codec.LONG.optionalFieldOf("seed", (Object)random.nextLong()).forGetter(ResearchData::seed)).apply((Applicative)instance, ResearchData::new));
        public static final ResearchData EMPTY = new ResearchData(ResourceLocation.parse((String)"eidolon:dummy"), 0);

        public ResearchData(ResourceLocation research, int stepsDone) {
            this(research, stepsDone, random.nextLong());
        }
    }
}

