/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import elucent.eidolon.api.research.Research;
import elucent.eidolon.common.item.ItemBase;
import elucent.eidolon.common.item.ResearchNotesItem;
import elucent.eidolon.registries.EidolonDataComponents;
import elucent.eidolon.registries.Researches;
import elucent.eidolon.util.KnowledgeUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class CompletedResearchItem
extends ItemBase {
    public CompletedResearchItem(Item.Properties builderIn) {
        super(builderIn.component(EidolonDataComponents.RESEARCH, (Object)ResearchNotesItem.ResearchData.EMPTY));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        ResearchNotesItem.ResearchData researchData = (ResearchNotesItem.ResearchData)stack.get(EidolonDataComponents.RESEARCH);
        if (researchData == null) {
            return;
        }
        Research r = Researches.find(researchData.research());
        if (r == null) {
            return;
        }
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.ITALIC) + String.valueOf(ChatFormatting.GOLD) + r.getName())));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        Research r;
        ResearchNotesItem.ResearchData researchData = (ResearchNotesItem.ResearchData)player.getItemInHand(hand).get(EidolonDataComponents.RESEARCH);
        if (researchData != null && (r = Researches.find(researchData.research())) != null && !KnowledgeUtil.knowsResearch(player, r.getRegistryName())) {
            KnowledgeUtil.grantResearch((Entity)player, r);
            return InteractionResultHolder.consume((Object)ItemStack.EMPTY);
        }
        return super.use(level, player, hand);
    }
}

