/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.common.entity.ChantCasterEntity;
import elucent.eidolon.common.item.ItemBase;
import elucent.eidolon.registries.EidolonDataComponents;
import elucent.eidolon.util.ClientInfo;
import elucent.eidolon.util.RenderUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ChantScrollItem
extends ItemBase {
    public ChantScrollItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        List spell;
        if (!pLevel.isClientSide() && pPlayer.getItemInHand(pUsedHand).has(EidolonDataComponents.SPELL) && !(spell = (List)pPlayer.getItemInHand(pUsedHand).getOrDefault(EidolonDataComponents.SPELL, List.of())).isEmpty()) {
            ChantCasterEntity.createChanter(pPlayer, pLevel, spell);
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public record ChantTooltipInfo(ItemStack stack, int maxWidth) implements TooltipComponent
    {
    }

    public static class ChantTooltipComponent
    implements ClientTooltipComponent {
        final ItemStack stack;
        final int maxWidth;

        public ChantTooltipComponent(ChantTooltipInfo info) {
            this.stack = info.stack;
            this.maxWidth = info.maxWidth;
        }

        public int getHeight() {
            int charge = ((List)this.stack.getOrDefault(EidolonDataComponents.SPELL, List.of())).size();
            int rows = (charge + 15) / 8;
            return charge == 0 ? 0 : 12 * rows;
        }

        public int getWidth(@NotNull Font font) {
            return this.maxWidth;
        }

        public void renderImage(@NotNull Font pFont, int pX, int pY, @NotNull GuiGraphics pGuiGraphics) {
            List spell = (List)this.stack.getOrDefault(EidolonDataComponents.SPELL, List.of());
            if (spell.isEmpty()) {
                return;
            }
            int spellSize = spell.size();
            for (int i = 0; i < spellSize; ++i) {
                Sign sign = (Sign)spell.get(i);
                PoseStack mStack = pGuiGraphics.pose();
                MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                RenderSystem.setShader(ClientRegistry::getGlowingSpriteShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
                float flicker = 0.75f + 0.05f * (float)Math.sin(Math.toRadians(12.0f * ClientInfo.getClientPartialTicks() - 360.0f * (float)i / (float)spell.size()));
                for (int j = 0; j < 2; ++j) {
                    RenderUtil.litQuad(mStack, (MultiBufferSource)bufferSource, 2 + pX + 17 * (i % 7), pY + 16 * (int)((float)i / 7.0f), 16.0, 16.0, sign.getRed() * flicker, sign.getGreen() * flicker, sign.getBlue() * flicker, (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(sign.sprite()));
                    bufferSource.endBatch();
                }
                RenderSystem.disableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
            }
        }
    }
}

