/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import elucent.eidolon.common.block.HerbBlockBase;
import elucent.eidolon.common.item.Tiers;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Registry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.NotNull;

public class AthameItem
extends SwordItem {
    String loreTag = null;
    public static final Map<Block, ItemStack> harvestables = new HashMap<Block, ItemStack>();

    public AthameItem(Item.Properties builderIn) {
        super((Tier)Tiers.PewterTier.INSTANCE, builderIn);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onHurt(LivingDamageEvent.Pre event) {
        LivingEntity living;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getMainHandItem().getItem() instanceof AthameItem && (event.getEntity() instanceof EnderMan || event.getEntity() instanceof Endermite || event.getEntity() instanceof EnderDragon)) {
            event.setNewDamage(event.getNewDamage() * 4.0f);
        }
    }

    public Item setLore(String tag) {
        this.loreTag = tag;
        return this;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        if (this.loreTag != null) {
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_PURPLE) + String.valueOf(ChatFormatting.ITALIC) + I18n.get((String)this.loreTag, (Object[])new Object[0]))));
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        RandomSource random = ctx.getPlayer() != null ? ctx.getPlayer().getRandom() : ctx.getLevel().getRandom();
        float hardness = state.getDestroySpeed((BlockGetter)ctx.getLevel(), ctx.getClickedPos());
        Block block = state.getBlock();
        if ((block instanceof BushBlock || block instanceof LeavesBlock || state.is(BlockTags.LEAVES) || state.is(BlockTags.CROPS) || state.is(BlockTags.FLOWERS) || block instanceof GrowingPlantBlock || block instanceof HerbBlockBase) && hardness < 5.0f && hardness >= 0.0f) {
            if (!ctx.getLevel().isClientSide) {
                Vec3 hit = ctx.getClickLocation();
                ((ServerLevel)ctx.getLevel()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), hit.x, hit.y, hit.z, 3, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, (double)0.05f);
                ctx.getLevel().playSound(null, ctx.getClickedPos(), SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 0.5f, 0.9f + random.nextFloat() * 0.2f);
                if (random.nextInt(3) == 0) {
                    if (state.is(Registry.PLANTER_PLANTS)) {
                        if ((Integer)state.getValue((Property)HerbBlockBase.AGE) == 2) {
                            ctx.getLevel().setBlockAndUpdate(ctx.getClickedPos(), (BlockState)state.setValue((Property)HerbBlockBase.AGE, (Comparable)Integer.valueOf(0)));
                            ItemStack drop = AthameItem.getHarvestable(block, ctx.getLevel());
                            if (!drop.isEmpty() && !ctx.getLevel().isClientSide) {
                                ctx.getLevel().playSound(null, ctx.getClickedPos(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 0.9f + random.nextFloat() * 0.2f);
                                for (int i = -1; i < random.nextInt(3); ++i) {
                                    ctx.getLevel().addFreshEntity((Entity)new ItemEntity(ctx.getLevel(), (double)ctx.getClickedPos().getX() + 0.5, (double)ctx.getClickedPos().getY() + 0.5, (double)ctx.getClickedPos().getZ() + 0.5, drop.copy()));
                                }
                            }
                            if (!ctx.getPlayer().isCreative()) {
                                ctx.getItemInHand().hurtAndBreak(1, (LivingEntity)ctx.getPlayer(), LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
                            }
                        }
                    } else {
                        if (block instanceof DoublePlantBlock && state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
                            ctx.getLevel().destroyBlock(ctx.getClickedPos().below(), false);
                        } else {
                            ctx.getLevel().destroyBlock(ctx.getClickedPos(), false);
                        }
                        Optional enchantmentHolder = ctx.getLevel().registryAccess().holder(Enchantments.LOOTING);
                        if (random.nextInt(10) >= 8 - (enchantmentHolder.isPresent() && ctx.getItemInHand().getItem() instanceof AthameItem ? ctx.getItemInHand().getEnchantmentLevel((Holder)enchantmentHolder.get()) : 0)) {
                            ItemStack drop = AthameItem.getHarvestable(block, ctx.getLevel());
                            if (!drop.isEmpty() && !ctx.getLevel().isClientSide) {
                                ctx.getLevel().playSound(null, ctx.getClickedPos(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 0.9f + random.nextFloat() * 0.2f);
                                ctx.getLevel().addFreshEntity((Entity)new ItemEntity(ctx.getLevel(), (double)ctx.getClickedPos().getX() + 0.5, (double)ctx.getClickedPos().getY() + 0.5, (double)ctx.getClickedPos().getZ() + 0.5, drop.copy()));
                            }
                            if (!ctx.getPlayer().isCreative()) {
                                ctx.getItemInHand().hurtAndBreak(1, (LivingEntity)ctx.getPlayer(), LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
                            }
                        }
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    public static void initHarvestables() {
        harvestables.put((Block)Registry.MERAMMER_ROOT.get(), new ItemStack((ItemLike)Registry.MERAMMER_ROOT.get()));
        harvestables.put((Block)Registry.OANNA_BLOOM.get(), new ItemStack((ItemLike)Registry.OANNA_BLOOM.get()));
        harvestables.put((Block)Registry.SILDRIAN_SEED.get(), new ItemStack((ItemLike)Registry.SILDRIAN_SEED.get()));
        harvestables.put((Block)Registry.AVENNIAN_SPRIG.get(), new ItemStack((ItemLike)Registry.AVENNIAN_SPRIG.get()));
        harvestables.put((Block)Registry.MIRECAP.get(), new ItemStack((ItemLike)Registry.MIRECAP.get()));
    }

    public static ItemStack getHarvestable(Block block, Level level) {
        ItemStack harvest = level.getRecipeManager().getAllRecipesFor((RecipeType)EidolonRecipes.FORAGING_TYPE.get()).stream().map(RecipeHolder::value).filter(foragingRecipe -> foragingRecipe.block.test(new ItemStack((ItemLike)block))).map(f -> f.getResultItem((HolderLookup.Provider)level.registryAccess())).findFirst().orElse(ItemStack.EMPTY);
        if (!harvest.isEmpty()) {
            return harvest;
        }
        return harvestables.getOrDefault(block, ItemStack.EMPTY);
    }
}

