/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.entity;

import elucent.eidolon.registries.EidolonPotions;
import elucent.eidolon.registries.EidolonSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WraithEntity
extends Monster {
    public WraithEntity(EntityType<WraithEntity> type, Level worldIn) {
        super(type, worldIn);
        this.registerGoals();
    }

    public boolean isInvertedHealAndHarm() {
        return true;
    }

    public boolean doHurtTarget(@NotNull Entity entityIn) {
        boolean flag = super.doHurtTarget(entityIn);
        if (flag && entityIn instanceof LivingEntity) {
            float f = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            ((LivingEntity)entityIn).addEffect(new MobEffectInstance(EidolonPotions.CHILLED_EFFECT, 100 + 100 * this.level().getDifficulty().getId()));
        }
        return flag;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.applyEntityAI();
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 0.0).build();
    }

    protected void applyEntityAI() {
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public int getBaseExperienceReward() {
        return 5;
    }

    public void aiStep() {
        FluidState below;
        if (this.level().isDay() && !this.level().isClientSide) {
            BlockPos blockpos;
            float f = this.getLightLevelDependentMagicValue();
            BlockPos blockPos = blockpos = this.getVehicle() instanceof Boat ? BlockPos.containing((double)this.getX(), (double)Math.round(this.getY()), (double)this.getZ()).above() : BlockPos.containing((double)this.getX(), (double)Math.round(this.getY()), (double)this.getZ());
            if (f > 0.5f && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.level().canSeeSky(blockpos)) {
                this.setRemainingFireTicks(160);
            }
        }
        if (!(below = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getFluidState()).isEmpty()) {
            Vec3 motion = this.getDeltaMovement();
            this.setOnGround(true);
            if (this.getY() + motion.y < (double)((float)this.getBlockPosBelowThatAffectsMyMovement().getY() + below.getOwnHeight())) {
                this.setNoGravity(true);
                if (motion.y < 0.0) {
                    this.setDeltaMovement(motion.multiply(1.0, 0.0, 1.0));
                }
                this.setPos(this.getX(), (float)this.getBlockPosBelowThatAffectsMyMovement().getY() + below.getOwnHeight(), this.getZ());
            }
        } else {
            this.setNoGravity(false);
        }
        this.fallDistance = 0.0f;
        Vec3 vector3d = this.getDeltaMovement();
        if (!this.onGround() && vector3d.y < 0.0) {
            this.setDeltaMovement(vector3d.multiply(1.0, 0.6, 1.0));
        }
        super.aiStep();
    }

    @NotNull
    public SoundEvent getDeathSound() {
        return (SoundEvent)EidolonSounds.WRAITH_DEATH.get();
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)EidolonSounds.WRAITH_AMBIENT.get();
    }

    @NotNull
    public SoundEvent getHurtSound(@NotNull DamageSource source) {
        return (SoundEvent)EidolonSounds.WRAITH_HURT.get();
    }
}

