/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.entity;

import elucent.eidolon.datagen.EidBiomeTagProvider;
import elucent.eidolon.registries.EidolonEntities;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlimySlugEntity
extends TamableAnimal {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.PUMPKIN_SEEDS});
    float yRotTrail = 0.0f;
    public float squishAmount = 1.0f;
    public int slimeTime = this.random.nextInt(12000) + 12000;
    public static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(SlimySlugEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public SlimySlugEntity(EntityType<SlimySlugEntity> type, Level worldIn) {
        super(type, worldIn);
        this.registerGoals();
        this.yRotTrail = this.getYRot();
        this.getEntityData().set(TYPE, (Object)0);
    }

    @NotNull
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        Holder holder = pLevel.getBiome(this.blockPosition());
        if (holder.is(EidBiomeTagProvider.BROWN_SLUG_TAG)) {
            this.setVariant(2);
        } else if (holder.is(EidBiomeTagProvider.BANANA_SLUG_TAG)) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    @Nullable
    public SlimySlugEntity getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        SlimySlugEntity offspring = (SlimySlugEntity)((EntityType)EidolonEntities.SLIMY_SLUG.get()).create((Level)serverLevel);
        if (offspring != null) {
            Holder holder = serverLevel.getBiome(this.blockPosition());
            if (holder.is(EidBiomeTagProvider.BROWN_SLUG_TAG)) {
                offspring.setVariant(2);
            } else if (holder.is(EidBiomeTagProvider.BANANA_SLUG_TAG)) {
                offspring.setVariant(1);
            } else {
                offspring.setVariant(0);
            }
        }
        return offspring;
    }

    private void setVariant(int type) {
        this.getEntityData().set(TYPE, (Object)type);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, e -> e.getItemBySlot(EquipmentSlot.HEAD).getItem().equals(Items.CARVED_PUMPKIN)));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 5.0f, 1.0f));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)TEMPTATION_ITEMS, false));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isFood(@NotNull ItemStack pStack) {
        return TEMPTATION_ITEMS.test(pStack);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 999.0).build();
    }

    public void tick() {
        super.tick();
        this.yRotTrail = Mth.rotLerp((float)this.yRotTrail, (float)this.getYRot(), (float)0.2f);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getItem() == Items.PUMPKIN_SEEDS) {
            if (!this.isTame()) {
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                if (!this.level().isClientSide) {
                    if (this.random.nextInt(10) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                        this.tame(player);
                        this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    } else {
                        this.level().broadcastEntityEvent((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            return super.mobInteract(player, hand);
        }
        if (this.onGround() && this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            if (!this.level().isClientSide) {
                this.setOrderedToSit(!this.isOrderedToSit());
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.isAlive() && !this.isBaby() && --this.slimeTime <= 0) {
            this.playSound(SoundEvents.SLIME_SQUISH, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.spawnAtLocation((ItemLike)Items.SLIME_BALL);
            this.slimeTime = this.random.nextInt(12000) + 12000;
        }
    }
}

