/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.entity;

import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.entity.SpellProjectileEntity;
import elucent.eidolon.network.MagicBurstEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.EidolonEntities;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.registries.EidolonPotions;
import elucent.eidolon.util.ColorUtil;
import elucent.eidolon.util.DamageTypeData;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class NecromancerSpellEntity
extends SpellProjectileEntity {
    public static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.defineId(NecromancerSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public NecromancerSpellEntity(EntityType<? extends SpellProjectileEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public NecromancerSpellEntity(Level worldIn, double x, double y, double z, double vx, double vy, double vz, int delay) {
        super((EntityType<? extends Projectile>)((EntityType)EidolonEntities.NECROMANCER_SPELL.get()), worldIn);
        this.setPos(x, y, z);
        this.setDeltaMovement(vx, vy, vz);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DELAY, (Object)0);
    }

    @Override
    public void tick() {
        if ((Integer)this.getEntityData().get(DELAY) > 0) {
            this.getEntityData().set(DELAY, (Object)((Integer)this.getEntityData().get(DELAY) - 1));
            return;
        }
        super.tick();
        Vec3 motion = this.getDeltaMovement();
        Vec3 pos = this.position();
        Vec3 norm = motion.normalize().scale((double)0.025f);
        for (int i = 0; i < 8; ++i) {
            double lerpX = Mth.lerp((double)((float)i / 8.0f), (double)this.xo, (double)pos.x);
            double lerpY = Mth.lerp((double)((float)i / 8.0f), (double)this.yo, (double)pos.y);
            double lerpZ = Mth.lerp((double)((float)i / 8.0f), (double)this.zo, (double)pos.z);
            Particles.create((ParticleType)EidolonParticles.WISP_PARTICLE.get()).addVelocity(-norm.x, -norm.y, -norm.z).setAlpha(0.375f, 0.0f).setScale(0.25f, 0.0f).setColor(1.0f, 0.3125f, 0.375f, 0.75f, 0.375f, 1.0f).setLifetime(5).spawn(this.level(), lerpX, lerpY, lerpZ);
            Particles.create((ParticleType)EidolonParticles.SMOKE_PARTICLE.get()).addVelocity(-norm.x, -norm.y, -norm.z).setAlpha(0.0625f, 0.0f).setScale(0.3125f, 0.125f).setColor(0.625f, 0.375f, 1.0f, 0.25f, 0.25f, 0.75f).randomVelocity(0.025f, 0.025f).setLifetime(20).spawn(this.level(), lerpX, lerpY, lerpZ);
        }
    }

    @Override
    protected void onImpact(HitResult ray, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.addEffect(new MobEffectInstance(EidolonPotions.VULNERABLE_EFFECT, 100));
        }
        Entity caster = this.getOwner();
        this.handleSpellDamage(caster, target, DamageTypeData.source((LevelAccessor)target.level(), (ResourceKey<DamageType>)DamageTypes.WITHER, (Entity)this, caster), 3 + this.level().getDifficulty().getId());
        this.onImpact(ray);
    }

    @Override
    protected void onImpact(HitResult ray) {
        this.removeAfterChangingDimensions();
        if (!this.level().isClientSide) {
            Vec3 pos = ray.getLocation();
            this.level().playSound(null, pos.x, pos.y, pos.z, SoundEvents.WITHER_SHOOT, SoundSource.HOSTILE, 0.5f, this.random.nextFloat() * 0.2f + 0.9f);
            Networking.sendToNearbyClient(this.level(), this.blockPosition(), (CustomPacketPayload)new MagicBurstEffectPacket(pos.x, pos.y, pos.z, ColorUtil.packColor(255, 158, 92, 255), ColorUtil.packColor(255, 60, 62, 186)));
        }
    }
}

