/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.entity;

import elucent.eidolon.api.capability.IReputation;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.entity.NecromancerSpellEntity;
import elucent.eidolon.network.MagicBurstEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.EidolonCapabilities;
import elucent.eidolon.registries.EidolonEntities;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.util.ColorUtil;
import elucent.eidolon.util.EntityUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class NecromancerEntity
extends SpellcasterIllager {
    boolean hack = false;

    public NecromancerEntity(EntityType<? extends SpellcasterIllager> type, Level worldIn) {
        super(type, worldIn);
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    public boolean isCastingSpell() {
        return (!this.level().isClientSide || !this.hack) && super.isCastingSpell();
    }

    public boolean isAlliedTo(@NotNull Entity pEntity) {
        if (pEntity == this) {
            return true;
        }
        if (super.isAlliedTo(pEntity)) {
            return true;
        }
        if (pEntity instanceof LivingEntity && pEntity.getType().is(EntityTypeTags.ILLAGER)) {
            return this.getTeam() == null && pEntity.getTeam() == null;
        }
        return false;
    }

    public void tick() {
        this.hack = true;
        super.tick();
        this.hack = false;
        if (this.level().isClientSide && this.isCastingSpell()) {
            SpellcasterIllager.IllagerSpell spelltype = this.getCurrentSpell();
            float f = this.yBodyRot * ((float)Math.PI / 180) + Mth.cos((float)((float)this.tickCount * 0.6662f)) * 0.25f;
            float f1 = Mth.cos((float)f);
            float f2 = Mth.sin((float)f);
            if (spelltype == SpellcasterIllager.IllagerSpell.FANGS) {
                Particles.create((ParticleType)EidolonParticles.SPARKLE_PARTICLE.get()).setColor(1.0f, 0.3125f, 0.375f, 0.75f, 0.375f, 1.0f).randomVelocity(0.05f).randomOffset(0.025f).setScale(0.25f, 0.125f).setAlpha(0.25f, 0.0f).setSpin(0.4f).spawn(this.level(), this.getX() + (double)f1 * 0.875, this.getY() + 2.0, this.getZ() + (double)f2 * 0.875).spawn(this.level(), this.getX() - (double)f1 * 0.875, this.getY() + 2.0, this.getZ() - (double)f2 * 0.875);
            } else if (spelltype == SpellcasterIllager.IllagerSpell.SUMMON_VEX) {
                Particles.create((ParticleType)EidolonParticles.WISP_PARTICLE.get()).setColor(0.75f, 1.0f, 1.0f, 0.125f, 0.125f, 0.875f).randomVelocity(0.05f).randomOffset(0.025f).setScale(0.25f, 0.125f).setAlpha(0.25f, 0.0f).spawn(this.level(), this.getX() + (double)f1 * 0.875, this.getY() + 2.0, this.getZ() + (double)f2 * 0.875).spawn(this.level(), this.getX() - (double)f1 * 0.875, this.getY() + 2.0, this.getZ() - (double)f2 * 0.875);
            }
        }
    }

    public boolean isInvertedHealAndHarm() {
        return true;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new CastingSpellGoal());
        this.goalSelector.addGoal(5, (Goal)new AttackSpellGoal());
        this.goalSelector.addGoal(4, (Goal)new SummonSpellGoal());
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, e -> {
            if (!(e instanceof Player)) {
                return false;
            }
            Player player = (Player)e;
            IReputation rep = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
            return rep != null && rep.getReputation(Deities.DARK_DEITY.getId()) >= 50.0;
        }).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void applyRaidBuffs(@NotNull ServerLevel level, int wave, boolean unused) {
    }

    @NotNull
    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 12.0).build();
    }

    @NotNull
    public SoundEvent getCelebrateSound() {
        return SoundEvents.EVOKER_CELEBRATE;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        private CastingSpellGoal() {
            super((SpellcasterIllager)NecromancerEntity.this);
        }

        public void tick() {
            if (NecromancerEntity.this.getTarget() != null) {
                NecromancerEntity.this.getLookControl().setLookAt((Entity)NecromancerEntity.this.getTarget(), (float)NecromancerEntity.this.getMaxHeadYRot(), (float)NecromancerEntity.this.getMaxHeadXRot());
            }
        }
    }

    class AttackSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private AttackSpellGoal() {
            super((SpellcasterIllager)NecromancerEntity.this);
        }

        public boolean canUse() {
            LivingEntity livingentity = NecromancerEntity.this.getTarget();
            if (livingentity != null && livingentity.isAlive()) {
                if (NecromancerEntity.this.isCastingSpell()) {
                    return false;
                }
                return NecromancerEntity.this.tickCount >= this.nextAttackTickCount;
            }
            return false;
        }

        protected int getCastingTime() {
            return 40;
        }

        protected int getCastingInterval() {
            return 80;
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        @NotNull
        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }

        protected void performSpellCasting() {
            LivingEntity target = NecromancerEntity.this.getTarget();
            Vec3 diff = target.position().subtract(NecromancerEntity.this.position());
            Vec3 norm = diff.normalize();
            if (!NecromancerEntity.this.level().isClientSide) {
                for (int i = 0; i < 3; ++i) {
                    NecromancerSpellEntity spell = new NecromancerSpellEntity(NecromancerEntity.this.level(), NecromancerEntity.this.getX(), NecromancerEntity.this.getEyeY(), NecromancerEntity.this.getZ(), norm.x + (double)NecromancerEntity.this.random.nextFloat() * 0.1 - 0.05, norm.y + 0.04 * diff.length() / 2.0 + (double)NecromancerEntity.this.random.nextFloat() * 0.1 - 0.05, norm.z + (double)NecromancerEntity.this.random.nextFloat() * 0.1 - 0.05, i * 5);
                    spell.setOwner((Entity)NecromancerEntity.this);
                    NecromancerEntity.this.level().addFreshEntity((Entity)spell);
                }
            }
        }
    }

    class SummonSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private SummonSpellGoal() {
            super((SpellcasterIllager)NecromancerEntity.this);
        }

        protected int getCastingTime() {
            return 40;
        }

        protected int getCastingInterval() {
            return 200;
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        @NotNull
        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }

        protected void performSpellCasting() {
            if (!NecromancerEntity.this.level().isClientSide) {
                EntityType type;
                EntityType entityType = type = NecromancerEntity.this.random.nextBoolean() ? EntityType.SKELETON : EntityType.ZOMBIE;
                if (NecromancerEntity.this.getHealth() < NecromancerEntity.this.getMaxHealth() / 2.0f) {
                    type = NecromancerEntity.this.random.nextBoolean() ? (EntityType)EidolonEntities.GIANT_SKEL.get() : (EntityType)EidolonEntities.ZOMBIE_BRUTE.get();
                }
                Holder biomeKey = NecromancerEntity.this.level().getBiome(NecromancerEntity.this.blockPosition());
                for (int i = 0; i < NecromancerEntity.this.random.nextInt(5); ++i) {
                    Entity entity;
                    if (type == EntityType.SKELETON && biomeKey.is(Tags.Biomes.IS_COLD)) {
                        type = EntityType.STRAY;
                    }
                    if (type == EntityType.SKELETON && biomeKey.is(BiomeTags.IS_NETHER)) {
                        type = EntityType.WITHER_SKELETON;
                    }
                    if (type == EntityType.ZOMBIE && biomeKey.is(Tags.Biomes.IS_SANDY)) {
                        type = EntityType.HUSK;
                    }
                    if (type == EntityType.ZOMBIE && biomeKey.is(Tags.Biomes.IS_WET)) {
                        type = EntityType.DROWNED;
                    }
                    if (!((entity = type.create(NecromancerEntity.this.level())) instanceof Monster)) {
                        return;
                    }
                    Monster thrall = (Monster)entity;
                    thrall.setPos(NecromancerEntity.this.getX(), NecromancerEntity.this.getY(), NecromancerEntity.this.getZ());
                    NecromancerEntity.this.level().addFreshEntity(entity);
                    thrall.setTarget(NecromancerEntity.this.getTarget());
                    EntityUtil.enthrall((LivingEntity)NecromancerEntity.this, (LivingEntity)thrall);
                    thrall.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 999999, 0, false, false));
                    Networking.sendToNearbyClient(NecromancerEntity.this.level(), NecromancerEntity.this.blockPosition(), (CustomPacketPayload)new MagicBurstEffectPacket(NecromancerEntity.this.getX(), NecromancerEntity.this.getY() + 1.0, NecromancerEntity.this.getZ(), ColorUtil.packColor(255, 181, 255, 255), ColorUtil.packColor(255, 28, 31, 212)));
                }
            }
        }
    }
}

