/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.entity;

import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.entity.SpellProjectileEntity;
import elucent.eidolon.network.MagicBurstEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.registries.EidolonPotions;
import elucent.eidolon.registries.EidolonSounds;
import elucent.eidolon.util.ColorUtil;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BonechillProjectileEntity
extends SpellProjectileEntity {
    public BonechillProjectileEntity(EntityType<? extends SpellProjectileEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            Vec3 motion = this.getDeltaMovement();
            Vec3 pos = this.position();
            Vec3 norm = motion.normalize().scale((double)0.025f);
            for (int i = 0; i < 8; ++i) {
                double lerpX = Mth.lerp((double)((float)i / 8.0f), (double)this.xOld, (double)pos.x);
                double lerpY = Mth.lerp((double)((float)i / 8.0f), (double)this.yOld, (double)pos.y);
                double lerpZ = Mth.lerp((double)((float)i / 8.0f), (double)this.zOld, (double)pos.z);
                Particles.create((ParticleType)EidolonParticles.WISP_PARTICLE.get()).addVelocity(-norm.x, -norm.y, -norm.z).setAlpha(0.0625f, 0.0f).setScale(0.625f, 0.0f).setColor(0.875f, 1.0f, 1.0f, 0.375f, 0.5f, 0.75f).setLifetime(5).spawn(this.level(), lerpX, lerpY, lerpZ);
                Particles.create((ParticleType)EidolonParticles.WISP_PARTICLE.get()).addVelocity(-norm.x, -norm.y, -norm.z).setAlpha(0.125f, 0.0f).setScale(0.25f, 0.125f).setColor(1.0f, 0.75f, 0.875f, 0.375f, 0.5f, 0.75f).setLifetime(20).spawn(this.level(), lerpX, lerpY, lerpZ);
            }
        }
    }

    @Override
    protected void onImpact(HitResult ray, Entity target) {
        Entity caster = this.getOwner();
        this.handleSpellDamage(caster, target, target.damageSources().indirectMagic((Entity)this, caster), 4.0f);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.addEffect(new MobEffectInstance(EidolonPotions.CHILLED_EFFECT, 300, 0));
        }
        this.onImpact(ray);
    }

    @Override
    protected void onImpact(HitResult ray) {
        this.kill();
        if (!this.level().isClientSide) {
            Vec3 pos = ray.getLocation();
            this.level().playSound(null, pos.x, pos.y, pos.z, (SoundEvent)EidolonSounds.SPLASH_BONECHILL_EVENT.get(), SoundSource.NEUTRAL, 0.5f, this.random.nextFloat() * 0.2f + 0.9f);
            Networking.sendToNearbyClient(this.level(), this.blockPosition(), (CustomPacketPayload)new MagicBurstEffectPacket(pos.x, pos.y, pos.z, ColorUtil.packColor(255, 192, 224, 255), ColorUtil.packColor(255, 96, 128, 192)));
        }
    }
}

