/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.block;

import elucent.eidolon.common.block.BlockBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class TwoHighHorizontalBlockBase
extends BlockBase {
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;

    public TwoHighHorizontalBlockBase(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        return super.canSurvive(state, world, pos) && world.isEmptyBlock(pos.above());
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, @NotNull ItemStack stack) {
        world.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.TOP)).setValue((Property)HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)HORIZONTAL_FACING))));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.BOTTOM)).setValue((Property)HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    public void breakBlock(BlockState state, Level world, BlockPos pos) {
        if (state.getValue(HALF) == Half.BOTTOM && world.getBlockState(pos.above()).getBlock() == this) {
            world.destroyBlock(pos.above(), false);
        } else if (state.getValue(HALF) == Half.TOP && world.getBlockState(pos.below()).getBlock() == this) {
            world.destroyBlock(pos.below(), false);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF}).add(new Property[]{HORIZONTAL_FACING});
    }
}

