/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.block;

import elucent.eidolon.common.block.HorizontalWaterloggableBlock;
import elucent.eidolon.common.tile.NecroticFocusTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class NecroticFocusBlock
extends HorizontalWaterloggableBlock
implements EntityBlock {
    final VoxelShape SOUTH = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5);
    final VoxelShape NORTH = Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
    final VoxelShape WEST = Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    final VoxelShape EAST = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0);

    public NecroticFocusBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    VoxelShape shapeForState(BlockState state) {
        return switch ((Direction)state.getValue((Property)HORIZONTAL_FACING)) {
            case Direction.NORTH -> this.NORTH;
            case Direction.SOUTH -> this.SOUTH;
            case Direction.WEST -> this.WEST;
            default -> this.EAST;
        };
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return this.shapeForState(state);
    }

    @Override
    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return this.shapeForState(state);
    }

    @Override
    @NotNull
    public VoxelShape getInteractionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return this.shapeForState(state);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new NecroticFocusTileEntity(pos, state);
    }
}

