/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.block;

import elucent.eidolon.common.block.BlockBase;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class HorizontalBlockBase
extends BlockBase {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;

    public HorizontalBlockBase(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)HORIZONTAL_FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)HORIZONTAL_FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue((Property)HORIZONTAL_FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)HORIZONTAL_FACING)));
    }

    @Nonnull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_FACING});
    }
}

