/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import elucent.eidolon.common.block.BlockBase;
import elucent.eidolon.registries.Registry;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EnchantedAshBlock
extends BlockBase {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.NORTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.EAST_REDSTONE;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.SOUTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.WEST_REDSTONE;
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    private static final VoxelShape BARRIER_SHAPE = Shapes.box((double)0.0, (double)-4.0, (double)0.0, (double)1.0, (double)5.0, (double)1.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<Direction, VoxelShape> SIDE_TO_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)Direction.SOUTH, (Object)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)Direction.EAST, (Object)Block.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)Direction.WEST, (Object)Block.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> SIDE_TO_ASCENDING_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or((VoxelShape)SIDE_TO_SHAPE.get(Direction.NORTH), (VoxelShape)Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)Direction.SOUTH, (Object)Shapes.or((VoxelShape)SIDE_TO_SHAPE.get(Direction.SOUTH), (VoxelShape)Block.box((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)Direction.EAST, (Object)Shapes.or((VoxelShape)SIDE_TO_SHAPE.get(Direction.EAST), (VoxelShape)Block.box((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)Direction.WEST, (Object)Shapes.or((VoxelShape)SIDE_TO_SHAPE.get(Direction.WEST), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private final Map<BlockState, VoxelShape> stateToShapeMap = Maps.newHashMap();
    private final BlockState sideBaseState;

    public EnchantedAshBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, (Comparable)RedstoneSide.NONE)).setValue(EAST, (Comparable)RedstoneSide.NONE)).setValue(SOUTH, (Comparable)RedstoneSide.NONE)).setValue(WEST, (Comparable)RedstoneSide.NONE));
        this.sideBaseState = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, (Comparable)RedstoneSide.SIDE)).setValue(EAST, (Comparable)RedstoneSide.SIDE)).setValue(SOUTH, (Comparable)RedstoneSide.SIDE)).setValue(WEST, (Comparable)RedstoneSide.SIDE);
        for (BlockState blockstate : this.getStateDefinition().getPossibleStates()) {
            this.stateToShapeMap.put(blockstate, this.getShapeForState(blockstate));
        }
    }

    private VoxelShape getShapeForState(BlockState state) {
        VoxelShape voxelshape = BASE_SHAPE;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.getValue((Property)FACING_PROPERTY_MAP.get(direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SIDE_TO_SHAPE.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SIDE_TO_ASCENDING_SHAPE.get(direction));
        }
        return voxelshape;
    }

    private static boolean areAllSidesInvalid(BlockState state) {
        return !((RedstoneSide)state.getValue(NORTH)).isConnected() && !((RedstoneSide)state.getValue(SOUTH)).isConnected() && !((RedstoneSide)state.getValue(EAST)).isConnected() && !((RedstoneSide)state.getValue(WEST)).isConnected();
    }

    private static boolean areAllSidesValid(BlockState state) {
        return ((RedstoneSide)state.getValue(NORTH)).isConnected() && ((RedstoneSide)state.getValue(SOUTH)).isConnected() && ((RedstoneSide)state.getValue(EAST)).isConnected() && ((RedstoneSide)state.getValue(WEST)).isConnected();
    }

    private BlockState recalculateFacingState(BlockGetter reader, BlockState state, BlockPos pos) {
        boolean flag = !reader.getBlockState(pos.above()).isRedstoneConductor(reader, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.getValue((Property)FACING_PROPERTY_MAP.get(direction))).isConnected()) continue;
            RedstoneSide redstoneside = this.recalculateSide(reader, pos, direction, flag);
            state = (BlockState)state.setValue((Property)FACING_PROPERTY_MAP.get(direction), (Comparable)redstoneside);
        }
        return state;
    }

    private RedstoneSide getSide(BlockGetter worldIn, BlockPos pos, Direction face) {
        return this.recalculateSide(worldIn, pos, face, !worldIn.getBlockState(pos.above()).isRedstoneConductor(worldIn, pos));
    }

    public void updateIndirectNeighbourShapes(@NotNull BlockState state, @NotNull LevelAccessor worldIn, @NotNull BlockPos pos, int flags, int recursionLeft) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.getValue((Property)FACING_PROPERTY_MAP.get(direction));
            if (redstoneside == RedstoneSide.NONE || worldIn.getBlockState((BlockPos)blockpos$mutable.setWithOffset((Vec3i)pos, direction)).is((Block)this)) continue;
            blockpos$mutable.move(Direction.DOWN);
            BlockState blockstate = worldIn.getBlockState((BlockPos)blockpos$mutable);
            if (!blockstate.is(Blocks.OBSERVER)) {
                BlockPos blockpos = blockpos$mutable.relative(direction.getOpposite());
                BlockState blockstate1 = blockstate.updateShape(direction.getOpposite(), worldIn.getBlockState(blockpos), worldIn, (BlockPos)blockpos$mutable, blockpos);
                EnchantedAshBlock.updateOrDestroy((BlockState)blockstate, (BlockState)blockstate1, (LevelAccessor)worldIn, (BlockPos)blockpos$mutable, (int)flags, (int)recursionLeft);
            }
            blockpos$mutable.setWithOffset((Vec3i)pos, direction).move(Direction.UP);
            BlockState blockstate3 = worldIn.getBlockState((BlockPos)blockpos$mutable);
            if (blockstate3.is(Blocks.OBSERVER)) continue;
            BlockPos blockpos1 = blockpos$mutable.relative(direction.getOpposite());
            BlockState blockstate2 = blockstate3.updateShape(direction.getOpposite(), worldIn.getBlockState(blockpos1), worldIn, (BlockPos)blockpos$mutable, blockpos1);
            EnchantedAshBlock.updateOrDestroy((BlockState)blockstate3, (BlockState)blockstate2, (LevelAccessor)worldIn, (BlockPos)blockpos$mutable, (int)flags, (int)recursionLeft);
        }
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        if (facing == Direction.UP) {
            return this.getUpdatedState((BlockGetter)worldIn, stateIn, currentPos);
        }
        RedstoneSide redstoneside = this.getSide((BlockGetter)worldIn, currentPos, facing);
        return redstoneside.isConnected() == ((RedstoneSide)stateIn.getValue((Property)FACING_PROPERTY_MAP.get(facing))).isConnected() && !EnchantedAshBlock.areAllSidesValid(stateIn) ? (BlockState)stateIn.setValue((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)redstoneside) : this.getUpdatedState((BlockGetter)worldIn, (BlockState)this.sideBaseState.setValue((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)redstoneside), currentPos);
    }

    private RedstoneSide recalculateSide(BlockGetter reader, BlockPos pos, Direction direction, boolean nonNormalCubeAbove) {
        boolean flag;
        BlockPos blockpos = pos.relative(direction);
        BlockState blockstate = reader.getBlockState(blockpos);
        if (nonNormalCubeAbove && (flag = this.canPlaceOnTopOf(reader, blockpos, blockstate)) && EnchantedAshBlock.canConnectTo(reader.getBlockState(blockpos.above()), reader, blockpos.above(), null)) {
            if (blockstate.isFaceSturdy(reader, blockpos, direction.getOpposite())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !EnchantedAshBlock.canConnectTo(blockstate, reader, blockpos, direction) && (blockstate.isRedstoneConductor(reader, blockpos) || !EnchantedAshBlock.canConnectTo(reader.getBlockState(blockpos.below()), reader, blockpos.below(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    private boolean canPlaceOnTopOf(BlockGetter reader, BlockPos pos, BlockState state) {
        return state.isFaceSturdy(reader, pos, Direction.UP);
    }

    private BlockState getUpdatedState(BlockGetter reader, BlockState state, BlockPos pos) {
        boolean flag = EnchantedAshBlock.areAllSidesInvalid(state);
        state = this.recalculateFacingState(reader, this.defaultBlockState(), pos);
        if (!flag || !EnchantedAshBlock.areAllSidesInvalid(state)) {
            boolean flag6;
            boolean flag1 = ((RedstoneSide)state.getValue(NORTH)).isConnected();
            boolean flag2 = ((RedstoneSide)state.getValue(SOUTH)).isConnected();
            boolean flag3 = ((RedstoneSide)state.getValue(EAST)).isConnected();
            boolean flag4 = ((RedstoneSide)state.getValue(WEST)).isConnected();
            boolean flag5 = !flag1 && !flag2;
            boolean bl = flag6 = !flag3 && !flag4;
            if (!flag4 && flag5) {
                state = (BlockState)state.setValue(WEST, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag3 && flag5) {
                state = (BlockState)state.setValue(EAST, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag1 && flag6) {
                state = (BlockState)state.setValue(NORTH, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag2 && flag6) {
                state = (BlockState)state.setValue(SOUTH, (Comparable)RedstoneSide.SIDE);
            }
        }
        return state;
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.stateToShapeMap.get(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getUpdatedState((BlockGetter)context.getLevel(), this.sideBaseState, context.getClickedPos());
    }

    public void onPlace(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock()) && !worldIn.isClientSide) {
            for (Direction direction : Direction.Plane.VERTICAL) {
                worldIn.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
            this.updateNeighboursStateChange(worldIn, pos);
        }
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return entity instanceof LivingEntity && ((LivingEntity)entity).isInvertedHealAndHarm();
    }

    boolean isBlocked(Entity entity) {
        LivingEntity living;
        if (entity == null) {
            return false;
        }
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).isInvertedHealAndHarm()) {
            return true;
        }
        return entity.getPassengers().stream().anyMatch(e -> e instanceof LivingEntity && ((LivingEntity)e).isInvertedHealAndHarm());
    }

    @Override
    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return ctx instanceof EntityCollisionContext && ((EntityCollisionContext)ctx).getEntity() != null && this.isBlocked(((EntityCollisionContext)ctx).getEntity()) ? BARRIER_SHAPE : super.getCollisionShape(state, world, pos, ctx);
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = worldIn.getBlockState(blockpos);
        return this.canPlaceOnTopOf((BlockGetter)worldIn, blockpos, blockstate);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!isMoving && !state.is(newState.getBlock())) {
            super.onRemove(state, worldIn, pos, newState, isMoving);
            if (!worldIn.isClientSide) {
                for (Direction direction : Direction.values()) {
                    worldIn.updateNeighborsAt(pos.relative(direction), (Block)this);
                }
                this.updateNeighboursStateChange(worldIn, pos);
            }
        }
    }

    private void updateChangedConnections(Level world, BlockPos pos, BlockState prevState, BlockState newState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.relative(direction);
            if (((RedstoneSide)prevState.getValue((Property)FACING_PROPERTY_MAP.get(direction))).isConnected() == ((RedstoneSide)newState.getValue((Property)FACING_PROPERTY_MAP.get(direction))).isConnected() || !world.getBlockState(blockpos).isRedstoneConductor((BlockGetter)world, blockpos)) continue;
            world.updateNeighborsAtExceptFromFacing(blockpos, newState.getBlock(), direction.getOpposite());
        }
    }

    private void notifyWireNeighborsOfStateChange(Level worldIn, BlockPos pos) {
        if (worldIn.getBlockState(pos).is((Block)this)) {
            worldIn.updateNeighborsAt(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
        }
    }

    private void updateNeighboursStateChange(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.notifyWireNeighborsOfStateChange(world, pos.relative(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.relative(direction1);
            if (world.getBlockState(blockpos).isRedstoneConductor((BlockGetter)world, blockpos)) {
                this.notifyWireNeighborsOfStateChange(world, blockpos.above());
                continue;
            }
            this.notifyWireNeighborsOfStateChange(world, blockpos.below());
        }
    }

    public void neighborChanged(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (!worldIn.isClientSide && !state.canSurvive((LevelReader)worldIn, pos)) {
            EnchantedAshBlock.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.removeBlock(pos, false);
        }
    }

    protected static boolean canConnectTo(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        return blockState.is((Block)Registry.ENCHANTED_ASH.get());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
    }
}

