/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.block;

import elucent.eidolon.common.block.BlockBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class CandlestickBlock
extends BlockBase {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", d -> d != Direction.DOWN);
    protected static final VoxelShape UP_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)16.0, (double)16.0), Block.box((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)16.0, (double)5.0), Block.box((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)16.0, (double)10.5), Block.box((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)16.0, (double)10.5)};

    public CandlestickBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static VoxelShape getShapeForState(BlockState state) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (dir == Direction.UP) {
            return UP_SHAPE;
        }
        return SHAPES[dir.ordinal() - 2];
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return CandlestickBlock.getShapeForState(state);
    }

    @Override
    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = worldIn.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)worldIn, blockpos, direction);
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (direction == Direction.UP) {
            return facing == Direction.DOWN && !this.canSurvive(state, (LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, worldIn, currentPos, facingPos);
        }
        return facing.getOpposite() == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : state;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.defaultBlockState();
        Level iworldreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : adirection = context.getNearestLookingDirections()) {
            Direction direction1;
            if (direction == Direction.UP || !(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)(direction1 = direction.getOpposite()))).canSurvive((LevelReader)iworldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, @NotNull Level worldIn, BlockPos pos, @NotNull RandomSource rand) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 0.925;
        double d2 = (double)pos.getZ() + 0.5;
        if (direction != Direction.UP) {
            d0 -= 0.3 * (double)direction.getStepX();
            d1 += 0.125;
            d2 -= 0.3 * (double)direction.getStepZ();
        }
        worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
        worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @NotNull
    public BlockState rotate(BlockState state, @NotNull Rotation rot) {
        return state.getValue((Property)FACING) != Direction.UP ? (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING))) : state;
    }

    @NotNull
    public BlockState mirror(BlockState state, @NotNull Mirror mirrorIn) {
        return state.getValue((Property)FACING) != Direction.UP ? state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING))) : state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

