/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.codex.Page;
import elucent.eidolon.util.ClientInfo;
import elucent.eidolon.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SignPage
extends Page {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"textures/gui/codex_sign_page.png");
    final Sign sign;

    public SignPage(Sign sign) {
        super(BACKGROUND);
        this.sign = sign;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics guiGraphics, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(ClientRegistry::getGlowingSpriteShader);
        PoseStack mStack = guiGraphics.pose();
        mStack.pushPose();
        mStack.translate((float)(x + 64), (float)(y + 80), 0.0f);
        mStack.mulPose(Axis.ZP.rotationDegrees(ClientInfo.getClientPartialTicks() * 1.5f));
        SignPage.colorBlit(mStack, -40, -40, 128, 96, 80, 80, 256, 256, this.sign.color());
        mStack.popPose();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        for (int i = 0; i < 2; ++i) {
            RenderUtil.litQuad(mStack, (MultiBufferSource)bufferSource, x + 44, y + 60, 40.0, 40.0, this.sign.getRed(), this.sign.getGreen(), this.sign.getBlue(), (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(this.sign.sprite()));
            bufferSource.endBatch();
        }
        RenderSystem.disableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }
}

