/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import elucent.eidolon.Eidolon;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.util.ColorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public abstract class Page {
    final ResourceLocation bg;

    public Page(ResourceLocation background) {
        this.bg = background;
    }

    public void reset() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawItem(GuiGraphics guiGraphics, ItemStack stack, int x, int y, int mouseX, int mouseY) {
        guiGraphics.renderItem(stack, x, y);
        Font font = Minecraft.getInstance().font;
        guiGraphics.renderItemDecorations(font, stack, x, y, null);
        if (mouseX >= x && mouseY >= y && mouseX <= x + 16 && mouseY <= y + 16) {
            guiGraphics.renderTooltip(font, stack, mouseX, mouseY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawItems(GuiGraphics guiGraphics, Ingredient ingredient, int x, int y, int mouseX, int mouseY) {
        if (ingredient.isEmpty()) {
            return;
        }
        ItemStack[] items = ingredient.getItems();
        ItemStack stack = items[(int)Eidolon.proxy.getWorld().getGameTime() / 20 % items.length];
        Page.drawItem(guiGraphics, stack, x, y, mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawText(GuiGraphics guiGraphics, String text, int x, int y) {
        Font font = Minecraft.getInstance().font;
        guiGraphics.drawString(font, text, x, y - 1, ColorUtil.packColor(128, 255, 255, 255), false);
        guiGraphics.drawString(font, text, x - 1, y, ColorUtil.packColor(128, 219, 212, 184), false);
        guiGraphics.drawString(font, text, x + 1, y, ColorUtil.packColor(128, 219, 212, 184), false);
        guiGraphics.drawString(font, text, x, y + 1, ColorUtil.packColor(128, 191, 179, 138), false);
        guiGraphics.drawString(font, text, x, y, ColorUtil.packColor(255, 79, 59, 47), false);
    }

    public static List<String> wrapTextToLines(String text, int maxWidth) {
        Font font = Minecraft.getInstance().font;
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        Object line = "";
        for (String word : words) {
            if (font.width((String)line) + font.width(word) > maxWidth) {
                lines.add(((String)line).trim());
                line = word + " ";
                continue;
            }
            line = (String)line + word + " ";
        }
        if (!((String)line).isEmpty()) {
            lines.add(((String)line).trim());
        }
        return lines;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawWrappingText(GuiGraphics mStack, String text, int x, int y, int w) {
        Font font = Minecraft.getInstance().font;
        String[] sentences = text.split("(?<=[.!?])\\s+");
        ArrayList<String> wrappedLines = new ArrayList<String>();
        for (String sentence : sentences) {
            List<String> sentenceLines = Page.wrapTextToLines(sentence, w);
            wrappedLines.addAll(sentenceLines);
        }
        for (int i = 0; i < wrappedLines.size(); ++i) {
            String string = (String)wrappedLines.get(i);
            Objects.requireNonNull(font);
            Page.drawText(mStack, string, x, y + i * (9 + 1));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fullRender(CodexGui gui, GuiGraphics mStack, int x, int y, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.bg);
        this.renderBackground(mStack, x, y, mouseX, mouseY);
        this.render(gui, mStack, this.bg, x, y, mouseX, mouseY);
        this.renderIngredients(gui, mStack, x, y, mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderBackground(@NotNull GuiGraphics mStack, int x, int y, int mouseX, int mouseY) {
        mStack.blit(this.bg, x, y, 0, 0, 128, 160);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean click(CodexGui gui, int x, int y, int mouseX, int mouseY) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics mStack, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderIngredients(CodexGui gui, GuiGraphics mStack, int x, int y, int mouseX, int mouseY) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void colorBlit(PoseStack mStack, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight, int color) {
        Matrix4f matrix = mStack.last().pose();
        int maxX = x + width;
        int maxY = y + height;
        float minU = (float)uOffset / (float)textureWidth;
        float minV = (float)vOffset / (float)textureHeight;
        float maxU = minU + (float)width / (float)textureWidth;
        float maxV = minV + (float)height / (float)textureHeight;
        int r = ColorUtil.getRed(color);
        int g = ColorUtil.getGreen(color);
        int b = ColorUtil.getBlue(color);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix, (float)x, (float)maxY, 0.0f).setUv(minU, maxV).setColor(r, g, b, 255);
        bufferbuilder.addVertex(matrix, (float)maxX, (float)maxY, 0.0f).setUv(maxU, maxV).setColor(r, g, b, 255);
        bufferbuilder.addVertex(matrix, (float)maxX, (float)y, 0.0f).setUv(maxU, minV).setColor(r, g, b, 255);
        bufferbuilder.addVertex(matrix, (float)x, (float)y, 0.0f).setUv(minU, minV).setColor(r, g, b, 255);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
    }
}

