/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import elucent.eidolon.Eidolon;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.codex.RecipePage;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CraftingPage
extends RecipePage<CraftingRecipe> {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"textures/gui/codex_crafting_page.png");

    public CraftingPage(ItemStack result) {
        super(BACKGROUND, BuiltInRegistries.ITEM.getKey((Object)result.getItem()), result);
    }

    public CraftingPage(Item result) {
        super(BACKGROUND, BuiltInRegistries.ITEM.getKey((Object)result), result.getDefaultInstance());
    }

    public CraftingPage(ItemStack result, ResourceLocation recipeId) {
        super(BACKGROUND, recipeId, result);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderIngredients(CodexGui gui, GuiGraphics mStack, int x, int y, int mouseX, int mouseY) {
        if (this.cachedRecipe == null) {
            return;
        }
        NonNullList inputs = ((CraftingRecipe)this.cachedRecipe).getIngredients();
        int width = 3;
        int height = 3;
        Recipe recipe = this.cachedRecipe;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            width = shaped.getWidth();
            height = shaped.getHeight();
        }
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int index = i * width + j;
                if (index >= inputs.size() || ((Ingredient)inputs.get(index)).isEmpty()) continue;
                CraftingPage.drawItems(mStack, (Ingredient)inputs.get(index), x + 36 + j * 20, y + 36 + i * 20, mouseX, mouseY);
            }
        }
        CraftingPage.drawItem(mStack, this.result, x + 56, y + 112, mouseX, mouseY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CraftingRecipe getRecipe(ResourceLocation id) {
        CraftingRecipe craftingRecipe;
        Recipe recipe;
        Optional recipeHolder = Eidolon.proxy.getWorld().getRecipeManager().byKey(id);
        if (recipeHolder.isEmpty() || !((recipe = ((RecipeHolder)recipeHolder.get()).value()) instanceof CraftingRecipe)) {
            craftingRecipe = null;
        } else {
            void var3_4;
            CraftingRecipe recipe2 = (CraftingRecipe)recipe;
            craftingRecipe = var3_4;
        }
        return craftingRecipe;
    }
}

