/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.client.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.client.model.NecromancerModel;
import elucent.eidolon.common.entity.NecromancerEntity;
import elucent.eidolon.util.ColorUtil;
import elucent.eidolon.util.RenderUtil;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class NecromancerRenderer
extends MobRenderer<NecromancerEntity, NecromancerModel> {
    public NecromancerRenderer(EntityRendererProvider.Context erm) {
        super(erm, (EntityModel)new NecromancerModel(erm.bakeLayer(ClientRegistry.NECROMANCER_LAYER)), 0.6f);
        this.addLayer(new NecromancerEyesLayer((RenderLayerParent<NecromancerEntity, NecromancerModel>)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull NecromancerEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"textures/entity/necromancer.png");
    }

    public static class NecromancerEyesLayer
    extends RenderLayer<NecromancerEntity, NecromancerModel> {
        final NecromancerModel model;
        private static final RenderType RENDER_TYPE = RenderType.create((String)"eidolon:necromancer_eyes", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(ClientRegistry::getGlowingEntityShader)).setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false)).setLightmapState(new RenderStateShard.LightmapStateShard(false)).setTransparencyState(RenderUtil.ADDITIVE_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"textures/entity/necromancer_eyes.png"), false, false)).createCompositeState(false));

        public NecromancerEyesLayer(RenderLayerParent<NecromancerEntity, NecromancerModel> entityRendererIn) {
            super(entityRendererIn);
            this.model = (NecromancerModel)entityRendererIn.getModel();
        }

        public RenderType getRenderType() {
            return RENDER_TYPE;
        }

        public void render(@NotNull PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, @NotNull NecromancerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(this.getRenderType());
            this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.model.renderToBuffer(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.NO_OVERLAY, ColorUtil.packColor(1, 1, 1, 1));
        }
    }
}

