/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.client.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.registries.Runes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RuneParticleData
implements ParticleOptions {
    final Rune rune;
    final float r1;
    final float g1;
    final float b1;
    final float r2;
    final float g2;
    final float b2;

    public static MapCodec<RuneParticleData> codecFor() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("rune").forGetter(d -> d.rune.getRegistryName().toString()), (App)Codec.FLOAT.fieldOf("r1").forGetter(d -> Float.valueOf(d.r1)), (App)Codec.FLOAT.fieldOf("g1").forGetter(d -> Float.valueOf(d.g1)), (App)Codec.FLOAT.fieldOf("b1").forGetter(d -> Float.valueOf(d.b1)), (App)Codec.FLOAT.fieldOf("r2").forGetter(d -> Float.valueOf(d.r2)), (App)Codec.FLOAT.fieldOf("g2").forGetter(d -> Float.valueOf(d.g2)), (App)Codec.FLOAT.fieldOf("b2").forGetter(d -> Float.valueOf(d.b2))).apply((Applicative)instance, (rune, r1, g1, b1, r2, g2, b2) -> new RuneParticleData(Runes.find(ResourceLocation.parse((String)rune)), r1.floatValue(), g1.floatValue(), b1.floatValue(), r2.floatValue(), g2.floatValue(), b2.floatValue())));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, RuneParticleData> streamCodecFor() {
        return StreamCodec.of((buf, data) -> {
            buf.writeResourceLocation(data.rune.getRegistryName());
            buf.writeFloat(data.r1);
            buf.writeFloat(data.g1);
            buf.writeFloat(data.b1);
            buf.writeFloat(data.r2);
            buf.writeFloat(data.g2);
            buf.writeFloat(data.b2);
        }, buf -> {
            ResourceLocation runeName = buf.readResourceLocation();
            float r1 = buf.readFloat();
            float g1 = buf.readFloat();
            float b1 = buf.readFloat();
            float r2 = buf.readFloat();
            float g2 = buf.readFloat();
            float b2 = buf.readFloat();
            return new RuneParticleData(Runes.find(runeName), r1, g1, b1, r2, g2, b2);
        });
    }

    public RuneParticleData(Rune rune, float r1, float g1, float b1, float r2, float g2, float b2) {
        this.rune = rune;
        this.r1 = r1;
        this.g1 = g1;
        this.b1 = b1;
        this.r2 = r2;
        this.g2 = g2;
        this.b2 = b2;
    }

    @NotNull
    public ParticleType<?> getType() {
        return (ParticleType)EidolonParticles.RUNE_PARTICLE.get();
    }
}

