/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import elucent.eidolon.client.ClientConfig;
import elucent.eidolon.client.particle.GlowParticleRenderType;
import elucent.eidolon.client.particle.SlashParticleData;
import elucent.eidolon.event.ClientEvents;
import elucent.eidolon.util.RenderUtil;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GlowingSlashParticle
extends TextureSheetParticle {
    final SlashParticleData data;
    final float[] hsv1 = new float[3];
    final float[] hsv2 = new float[3];

    public GlowingSlashParticle(ClientLevel world, SlashParticleData data, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.setPos(x, y, z);
        this.data = data;
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        this.setLifetime(data.lifetime);
        Vec3 dir = Vec3.directionFromRotation((float)(57.295776f * -data.pitch), (float)(57.295776f * -data.yaw));
        this.xd += dir.x * (double)(0.025f + world.random.nextFloat() * 0.025f);
        this.yd += dir.y * (double)(0.025f + world.random.nextFloat() * 0.025f);
        this.zd += dir.z * (double)(0.025f + world.random.nextFloat() * 0.025f);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r1)), (int)(255.0f * Math.min(1.0f, data.g1)), (int)(255.0f * Math.min(1.0f, data.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r2)), (int)(255.0f * Math.min(1.0f, data.g2)), (int)(255.0f * Math.min(1.0f, data.b2)), this.hsv2);
        this.updateTraits();
    }

    protected float getCoeff() {
        return (float)this.age / (float)this.lifetime;
    }

    protected float getCoeff(float pticks) {
        return ((float)this.age + pticks) / (float)this.lifetime;
    }

    protected float getSqInvCoeff(float pticks) {
        float inv = ((float)this.lifetime - (float)this.age + pticks) / (float)this.lifetime;
        return inv * inv;
    }

    protected void updateTraits() {
        float coeff = this.getCoeff();
        float h = Mth.rotLerp((float)coeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = Mth.lerp((float)coeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = Mth.lerp((float)coeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.red((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)packed) / 255.0f;
        this.setColor(r, g, b);
        this.setAlpha(Mth.lerp((float)coeff, (float)this.data.a1, (float)this.data.a2));
    }

    public void tick() {
        this.updateTraits();
        super.tick();
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return GlowParticleRenderType.INSTANCE;
    }

    private void decoVert(VertexConsumer vc, float u, float v, float alpha, int lmap) {
        vc.setUv(u, v).setColor(this.rCol, this.gCol, this.bCol, alpha).setLight(lmap);
    }

    public void render(@NotNull VertexConsumer vc, Camera info, float pticks) {
        VertexConsumer b = (Boolean)ClientConfig.BETTER_LAYERING.get() != false ? ClientEvents.getDelayedRender().getBuffer(RenderUtil.DELAYED_PARTICLE) : vc;
        float x = (float)(Mth.lerp((double)pticks, (double)this.xo, (double)this.x) - info.getPosition().x());
        float y = (float)(Mth.lerp((double)pticks, (double)this.yo, (double)this.y) - info.getPosition().y());
        float z = (float)(Mth.lerp((double)pticks, (double)this.zo, (double)this.z) - info.getPosition().z());
        float sy = Mth.sin((float)this.data.yaw);
        float cy = Mth.cos((float)this.data.yaw);
        float sp = Mth.sin((float)this.data.pitch);
        float cp = Mth.cos((float)this.data.pitch);
        float ox = x - sy * cp * this.data.rad;
        float oy = y - sp * this.data.rad;
        float oz = z - cy * cp * this.data.rad;
        float right = this.data.yaw + 1.5707964f;
        float up = this.data.pitch + 1.5707964f;
        float sr = Mth.sin((float)right);
        float cr = Mth.cos((float)right);
        float su = Mth.sin((float)up);
        float cu = Mth.cos((float)up);
        float r = this.data.rad;
        float xax = r * sr * cp;
        float xay = 0.0f;
        float xaz = r * cr * cp;
        float yax = r * sy * cu;
        float yay = r * su;
        float yaz = r * cy * cu;
        float zax = r * sy * cp;
        float zay = r * sp;
        float zaz = r * cy * cp;
        float cro = Mth.cos((float)this.data.roll);
        float sro = Mth.sin((float)this.data.roll);
        float nxax = xax * cro - yax * sro;
        float nxay = xay * cro - yay * sro;
        float nxaz = xaz * cro - yaz * sro;
        xax = nxax;
        xay = nxay;
        xaz = nxaz;
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int lmap = this.getLightColor(pticks);
        float w = this.data.width / 2.0f;
        float hlangle = -this.data.angle / 2.0f + this.getSqInvCoeff(pticks) * this.data.angle;
        float hlwidth = 4.0f + 4.0f * this.getSqInvCoeff(pticks);
        for (float i = 0.0f; i < 18.0f; i += 1.0f) {
            float c1 = i / 18.0f;
            float c2 = (i + 1.0f) / 18.0f;
            float angle1 = -this.data.angle / 2.0f + c1 * this.data.angle;
            float angle2 = -this.data.angle / 2.0f + c2 * this.data.angle;
            float al1 = Mth.sin((float)(c1 * (float)Math.PI));
            float al2 = Mth.sin((float)(c2 * (float)Math.PI));
            float dangle1 = Mth.clamp((float)((angle1 - hlangle) / this.data.angle), (float)(-1.0f / hlwidth), (float)(1.0f / hlwidth));
            float dangle2 = Mth.clamp((float)((angle2 - hlangle) / this.data.angle), (float)(-1.0f / hlwidth), (float)(1.0f / hlwidth));
            float hl1 = (Mth.cos((float)(hlwidth * (float)Math.PI * dangle1)) + 1.0f) / 2.0f;
            float hl2 = (Mth.cos((float)(hlwidth * (float)Math.PI * dangle2)) + 1.0f) / 2.0f;
            al1 = (1.0f - this.data.highlight) * al1 + this.data.highlight * hl1;
            al2 = (1.0f - this.data.highlight) * al2 + this.data.highlight * hl2;
            al1 *= this.alpha;
            al2 *= this.alpha;
            float w1 = w * (0.25f + 0.75f * Mth.sin((float)(c1 * (float)Math.PI)));
            float w2 = w * (0.25f + 0.75f * Mth.sin((float)(c2 * (float)Math.PI)));
            w1 += this.data.highlight * 0.25f * w * hl1;
            w2 += this.data.highlight * 0.25f * w * hl2;
            float sa1 = Mth.sin((float)angle1);
            float ca1 = Mth.cos((float)angle1);
            float sa2 = Mth.sin((float)angle2);
            float ca2 = Mth.cos((float)angle2);
            float dx1 = sa1 * xax + ca1 * zax;
            float dy1 = sa1 * xay + ca1 * zay;
            float dz1 = sa1 * xaz + ca1 * zaz;
            float dx2 = sa2 * xax + ca2 * zax;
            float dy2 = sa2 * xay + ca2 * zay;
            float dz2 = sa2 * xaz + ca2 * zaz;
            this.decoVert(b, ox, dx2, r, w2, oy, dy2, oz, dz2, u1, v1, al2, lmap, v0, dx1, w1, dy1, dz1, u0, al1);
            this.decoVert(b, ox, dx2, r, w2, oy, dy2, oz, dz2, u1, v1, al2, lmap, v0, dx1, w1, dy1, dz1, u0, al1);
        }
    }

    private void decoVert(VertexConsumer b, float ox, float dx2, float r, float w2, float oy, float dy2, float oz, float dz2, float u1, float v1, float al2, int lmap, float v0, float dx1, float w1, float dy1, float dz1, float u0, float al1) {
        this.decoVert(b.addVertex(ox + dx2 * r + dx2 * w2, oy + dy2 * r + dy2 * w2, oz + dz2 * r + dz2 * w2), u1, v1, al2, lmap);
        this.decoVert(b.addVertex(ox + dx2 * r + dx2 * -w2, oy + dy2 * r + dy2 * -w2, oz + dz2 * r + dz2 * -w2), u1, v0, al2, lmap);
        this.decoVert(b.addVertex(ox + dx1 * r + dx1 * -w1, oy + dy1 * r + dy1 * -w1, oz + dz1 * r + dz1 * -w1), u0, v0, al1, lmap);
        this.decoVert(b.addVertex(ox + dx1 * r + dx1 * w1, oy + dy1 * r + dy1 * w1, oz + dz1 * r + dz1 * w1), u0, v1, al1, lmap);
        this.decoVert(b.addVertex(ox + dx2 * r + dx2 * -w2, oy + dy2 * r + dy2 * -w2, oz + dz2 * r + dz2 * -w2), u1, v1, al2, lmap);
        this.decoVert(b.addVertex(ox + dx2 * r + dx2 * w2, oy + dy2 * r + dy2 * w2, oz + dz2 * r + dz2 * w2), u1, v0, al2, lmap);
        this.decoVert(b.addVertex(ox + dx1 * r + dx1 * w1, oy + dy1 * r + dy1 * w1, oz + dz1 * r + dz1 * w1), u0, v0, al1, lmap);
        this.decoVert(b.addVertex(ox + dx1 * r + dx1 * -w1, oy + dy1 * r + dy1 * -w1, oz + dz1 * r + dz1 * -w1), u0, v1, al1, lmap);
    }
}

