/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import elucent.eidolon.common.entity.WraithEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class WraithModel
extends EntityModel<WraithEntity> {
    private final ModelPart body;

    public WraithModel(ModelPart root) {
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -16.0f, -4.0f, 8.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(32, 2).addBox(-3.0f, -15.0f, -3.0f, 6.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 24).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(32, 26).addBox(-3.0f, 0.2588f, 0.9659f, 6.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-4.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 48).addBox(-1.5f, -1.5f, -1.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.5f, (float)-6.5f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)-0.1745f));
        PartDefinition lower_right_arm = right_arm.addOrReplaceChild("lower_right_arm", CubeListBuilder.create().texOffs(12, 48).addBox(-1.5f, -2.4749f, -2.6464f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_hand = lower_right_arm.addOrReplaceChild("right_hand", CubeListBuilder.create().texOffs(25, 48).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 48).mirror().addBox(-1.5f, -1.5f, -1.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)5.5f, (float)-6.5f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.1745f));
        PartDefinition lower_left_arm = left_arm.addOrReplaceChild("lower_left_arm", CubeListBuilder.create().texOffs(12, 48).mirror().addBox(9.5f, -2.4749f, -2.6464f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-11.0f, (float)6.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_hand = lower_left_arm.addOrReplaceChild("left_hand", CubeListBuilder.create().texOffs(25, 48).mirror().addBox(9.5f, -1.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(WraithEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.y = 8.0f + 1.5f * Mth.sin((float)(ageInTicks / 20.0f * (float)Math.PI));
        this.body.xRot = (float)Math.toRadians(Mth.clamp((float)(15.0f * (float)entity.getDeltaMovement().multiply(1.0, 0.0, 1.0).length() / 0.3f), (float)-15.0f, (float)15.0f));
        this.body.getChild((String)"right_arm").xRot = -1.0472f + Mth.cos((float)(limbSwing * 0.666f + (float)Math.PI)) * 0.25f * limbSwingAmount;
        this.body.getChild((String)"left_arm").xRot = -1.0472f + Mth.cos((float)(limbSwing * 0.666f)) * 0.25f * limbSwingAmount;
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

