/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import elucent.eidolon.common.entity.GiantSkeletonEntity;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class BruteSkeletonModel
extends HumanoidModel<GiantSkeletonEntity> {
    public BruteSkeletonModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 1).addBox(-6.0f, -2.25f, -4.15f, 12.0f, 15.0f, 6.0f, new CubeDeformation(0.25f)).texOffs(0, 41).addBox(-5.5f, 12.75f, -2.85f, 11.0f, 4.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-0.5f, (float)-7.25f, (float)0.15f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(36, 20).addBox(-4.5f, -9.5f, -5.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-9.5f, (float)-0.5f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(0.5f, -2.0f, -1.5f, 3.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.5f, (float)-6.0f, (float)-0.5f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 22).addBox(-4.5f, -2.0f, -1.5f, 3.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.5f, (float)-6.0f, (float)-0.5f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(12, 22).mirror().addBox(-2.5f, 0.0f, -0.5f, 3.0f, 14.0f, 3.0f, new CubeDeformation(0.125f)).mirror(false), PartPose.offset((float)3.5f, (float)10.0f, (float)-0.5f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(12, 22).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 14.0f, 3.0f, new CubeDeformation(0.125f)), PartPose.offset((float)-3.5f, (float)10.0f, (float)-0.5f));
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(36, 2).addBox(-4.5f, -9.5f, -5.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-0.5f, (float)-9.5f, (float)-0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    private float quadraticArmUpdate(float pLimbSwing) {
        return -65.0f * pLimbSwing + pLimbSwing * pLimbSwing;
    }

    public void setupAnim(@NotNull GiantSkeletonEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        boolean flag = pEntity.getFallFlyingTicks() > 4;
        boolean flag1 = pEntity.isVisuallySwimming();
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = flag ? -0.7853982f : (this.swimAmount > 0.0f ? (flag1 ? this.rotlerpRad(this.swimAmount, this.head.xRot, -0.7853982f) : this.rotlerpRad(this.swimAmount, this.head.xRot, pHeadPitch * ((float)Math.PI / 180))) : pHeadPitch * ((float)Math.PI / 180));
        this.body.yRot = 0.0f;
        this.rightArm.z = 0.0f;
        this.rightArm.x = -5.0f;
        this.leftArm.z = 0.0f;
        this.leftArm.x = 5.0f;
        float f = 1.0f;
        if (flag) {
            f = (float)pEntity.getDeltaMovement().lengthSqr();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.rightArm.xRot = Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 2.0f * pLimbSwingAmount * 0.5f / f;
        this.leftArm.xRot = Mth.cos((float)(pLimbSwing * 0.6662f)) * 2.0f * pLimbSwingAmount * 0.5f / f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount / f;
        this.leftLeg.xRot = Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount / f;
        this.rightLeg.yRot = 0.005f;
        this.leftLeg.yRot = -0.005f;
        this.rightLeg.zRot = 0.005f;
        this.leftLeg.zRot = -0.005f;
        if (this.riding) {
            this.rightArm.xRot += -0.62831855f;
            this.leftArm.xRot += -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        this.setupAttackAnimation((LivingEntity)pEntity, pAgeInTicks);
        if (this.rightArmPose != HumanoidModel.ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.rightArm, (float)pAgeInTicks, (float)1.0f);
        }
        if (this.leftArmPose != HumanoidModel.ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.leftArm, (float)pAgeInTicks, (float)-1.0f);
        }
        if (this.swimAmount > 0.0f) {
            float f2;
            float f5 = pLimbSwing % 26.0f;
            HumanoidArm humanoidarm = pEntity.getMainArm();
            float f1 = humanoidarm == HumanoidArm.RIGHT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            float f3 = f2 = humanoidarm == HumanoidArm.LEFT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            if (!pEntity.isUsingItem()) {
                if (f5 < 14.0f) {
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 0.0f);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)0.0f);
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI + 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f));
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)((float)Math.PI - 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f)));
                } else if (f5 >= 14.0f && f5 < 22.0f) {
                    float f6 = (f5 - 14.0f) / 8.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f * f6);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)(1.5707964f * f6));
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, 5.012389f - 1.8707964f * f6);
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)(1.2707963f + 1.8707964f * f6));
                } else if (f5 >= 22.0f && f5 < 26.0f) {
                    float f32 = (f5 - 22.0f) / 4.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f - 1.5707964f * f32);
                    this.rightArm.xRot = Mth.lerp((float)f1, (float)this.rightArm.xRot, (float)(1.5707964f - 1.5707964f * f32));
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp((float)f1, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI);
                    this.rightArm.zRot = Mth.lerp((float)f1, (float)this.rightArm.zRot, (float)((float)Math.PI));
                }
            }
            float f7 = 0.3f;
            float f4 = 0.33333334f;
            this.leftLeg.xRot = Mth.lerp((float)this.swimAmount, (float)this.leftLeg.xRot, (float)(f7 * Mth.cos((float)(pLimbSwing * f4 + (float)Math.PI))));
            this.rightLeg.xRot = Mth.lerp((float)this.swimAmount, (float)this.rightLeg.xRot, (float)(f7 * Mth.cos((float)(pLimbSwing * f4))));
        }
        this.hat.copyFrom(this.head);
        ItemStack itemstack = pEntity.getMainHandItem();
        if (pEntity.isAggressive() && (itemstack.isEmpty() || !itemstack.is(Items.BOW))) {
            f = Mth.sin((float)(this.attackTime * (float)Math.PI));
            float f1 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
            this.rightArm.zRot = 0.0f;
            this.leftArm.zRot = 0.0f;
            this.rightArm.yRot = -(0.1f - f * 0.6f);
            this.leftArm.yRot = 0.1f - f * 0.6f;
            this.rightArm.xRot = -1.5707964f;
            this.leftArm.xRot = -1.5707964f;
            this.rightArm.xRot -= f * 1.2f - f1 * 0.4f;
            this.leftArm.xRot -= f * 1.2f - f1 * 0.4f;
            AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)pAgeInTicks);
        }
    }

    public void translateToHand(@NotNull HumanoidArm pSide, @NotNull PoseStack pPoseStack) {
        float f = pSide == HumanoidArm.RIGHT ? -2.0f : -5.0f;
        float y = 4.0f;
        ModelPart modelpart = this.getArm(pSide);
        modelpart.x += f;
        modelpart.y += y;
        modelpart.translateAndRotate(pPoseStack);
        modelpart.x -= f;
        modelpart.y -= y;
    }
}

