/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import elucent.eidolon.api.capability.IKnowledge;
import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.registries.EidolonAttachments;
import elucent.eidolon.registries.Runes;
import elucent.eidolon.registries.Signs;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class KnowledgeImpl
implements IKnowledge {
    LivingEntity entity;
    KnowledgeData knowledgeData;

    public KnowledgeImpl(LivingEntity entity) {
        this.entity = entity;
        this.knowledgeData = (KnowledgeData)entity.getData(EidolonAttachments.KNOWLEDGE_ATTACHMENT.get());
    }

    @Override
    public boolean knowsSign(Sign sign) {
        return this.knowledgeData.getKnownSigns().contains(sign);
    }

    @Override
    public void addSign(Sign sign) {
        this.knowledgeData.addSign(sign);
    }

    @Override
    public void removeSign(Sign sign) {
        this.knowledgeData.removeSign(sign);
    }

    @Override
    public void resetSigns() {
        this.knowledgeData.resetSigns();
    }

    @Override
    public Set<Sign> getKnownSigns() {
        return this.knowledgeData.getKnownSigns();
    }

    @Override
    public boolean knowsFact(ResourceLocation fact) {
        return this.knowledgeData.getKnownFacts().contains(fact);
    }

    @Override
    public void addFact(ResourceLocation fact) {
        this.knowledgeData.addFact(fact);
    }

    @Override
    public void removeFact(ResourceLocation fact) {
        this.knowledgeData.removeFact(fact);
    }

    @Override
    public void resetFacts() {
        this.knowledgeData.resetFacts();
    }

    @Override
    public Set<ResourceLocation> getKnownFacts() {
        return this.knowledgeData.getKnownFacts();
    }

    @Override
    public boolean knowsResearch(ResourceLocation research) {
        return this.knowledgeData.getKnownResearches().contains(research);
    }

    @Override
    public void addResearch(ResourceLocation research) {
        this.knowledgeData.addResearch(research);
    }

    @Override
    public void removeResearch(ResourceLocation research) {
        this.knowledgeData.removeResearch(research);
    }

    @Override
    public void resetResearch() {
        this.knowledgeData.resetResearches();
    }

    @Override
    public Set<ResourceLocation> getKnownResearches() {
        return this.knowledgeData.getKnownResearches();
    }

    @Override
    public boolean knowsRune(Rune rune) {
        return this.knowledgeData.getKnownRunes().contains(rune);
    }

    @Override
    public void addRune(Rune rune) {
        this.knowledgeData.addRune(rune);
    }

    @Override
    public void removeRune(Rune rune) {
        this.knowledgeData.removeRune(rune);
    }

    @Override
    public void resetRunes() {
        this.knowledgeData.resetRunes();
    }

    @Override
    public Set<Rune> getKnownRunes() {
        return this.knowledgeData.getKnownRunes();
    }

    public KnowledgeData getKnowledgeData() {
        return this.knowledgeData;
    }

    public static class KnowledgeData
    implements INBTSerializable<CompoundTag> {
        private final Set<Sign> signs = new HashSet<Sign>();
        private final Set<ResourceLocation> facts = new HashSet<ResourceLocation>();
        private final Set<ResourceLocation> researches = new HashSet<ResourceLocation>();
        private final Set<Rune> runes = new HashSet<Rune>();

        public Set<Sign> getKnownSigns() {
            return this.signs;
        }

        public void addSign(Sign sign) {
            this.signs.add(sign);
        }

        public void removeSign(Sign sign) {
            this.signs.remove(sign);
        }

        public void resetSigns() {
            this.signs.clear();
        }

        public Set<ResourceLocation> getKnownFacts() {
            return this.facts;
        }

        public void addFact(ResourceLocation fact) {
            this.facts.add(fact);
        }

        public void removeFact(ResourceLocation fact) {
            this.facts.remove(fact);
        }

        public void resetFacts() {
            this.facts.clear();
        }

        public Set<ResourceLocation> getKnownResearches() {
            return this.researches;
        }

        public void addResearch(ResourceLocation research) {
            this.researches.add(research);
        }

        public void removeResearch(ResourceLocation research) {
            this.researches.remove(research);
        }

        public void resetResearches() {
            this.researches.clear();
        }

        public Set<Rune> getKnownRunes() {
            return this.runes;
        }

        public void addRune(Rune rune) {
            this.runes.add(rune);
        }

        public void removeRune(Rune rune) {
            this.runes.remove(rune);
        }

        public void resetRunes() {
            this.runes.clear();
        }

        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            ListTag signs = new ListTag();
            for (Sign sign : this.getKnownSigns()) {
                signs.add((Object)StringTag.valueOf((String)sign.getRegistryName().toString()));
            }
            ListTag facts = new ListTag();
            for (ResourceLocation resourceLocation : this.getKnownFacts()) {
                facts.add((Object)StringTag.valueOf((String)resourceLocation.toString()));
            }
            ListTag listTag = new ListTag();
            for (ResourceLocation resourceLocation : this.getKnownResearches()) {
                listTag.add((Object)StringTag.valueOf((String)resourceLocation.toString()));
            }
            ListTag listTag2 = new ListTag();
            for (Rune r : this.getKnownRunes()) {
                listTag2.add((Object)StringTag.valueOf((String)r.getRegistryName().toString()));
            }
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.put("signs", (Tag)signs);
            compoundTag.put("facts", (Tag)facts);
            compoundTag.put("researches", (Tag)listTag);
            compoundTag.put("runes", (Tag)listTag2);
            return compoundTag;
        }

        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            ResourceLocation loc;
            int i;
            ListTag list;
            this.resetSigns();
            this.resetFacts();
            this.resetResearches();
            this.resetRunes();
            if (nbt.contains("signs")) {
                list = nbt.getList("signs", 8);
                for (i = 0; i < list.size(); ++i) {
                    loc = ResourceLocation.tryParse((String)list.getString(i));
                    Sign s = Signs.find(loc);
                    if (s == null) continue;
                    this.addSign(s);
                }
            }
            if (nbt.contains("facts")) {
                list = nbt.getList("facts", 8);
                for (i = 0; i < list.size(); ++i) {
                    this.addFact(ResourceLocation.tryParse((String)list.getString(i)));
                }
            }
            if (nbt.contains("researches")) {
                list = nbt.getList("researches", 8);
                for (i = 0; i < list.size(); ++i) {
                    this.addResearch(ResourceLocation.tryParse((String)list.getString(i)));
                }
            }
            if (nbt.contains("runes")) {
                list = nbt.getList("runes", 8);
                for (i = 0; i < list.size(); ++i) {
                    loc = ResourceLocation.tryParse((String)list.getString(i));
                    Rune r = Runes.find(loc);
                    if (r == null) continue;
                    this.addRune(r);
                }
            }
        }
    }
}

