/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import elucent.eidolon.api.research.Research;
import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.registries.EidolonCapabilities;
import elucent.eidolon.registries.Researches;
import elucent.eidolon.registries.Runes;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.util.KnowledgeUtil;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class KnowledgeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"knowledge").requires(player -> player.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reset").then(Commands.literal((String)"signs").executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.resetSigns((Entity)player);
            }
        })))).then(Commands.literal((String)"facts").executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.resetFacts((Entity)player);
            }
        })))).then(Commands.literal((String)"research").executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.resetResearch((Entity)player);
            }
        })))).then(Commands.literal((String)"runes").executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.resetRunes((Entity)player);
            }
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"grant").then(Commands.literal((String)"sign").then(Commands.argument((String)"sign", (ArgumentType)new SignArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.grantSign((Entity)player, SignArgument.getSign(ctx, "sign"));
            }
        }))))).then(Commands.literal((String)"fact").then(Commands.argument((String)"fact", (ArgumentType)ResourceLocationArgument.id()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.grantFact((Entity)player, ResourceLocationArgument.getId((CommandContext)ctx, (String)"fact"));
            }
        }))))).then(Commands.literal((String)"research").then(Commands.argument((String)"research", (ArgumentType)new ResearchArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.grantResearch((Entity)player, ResearchArgument.getResearch(ctx, "research"));
            }
        }))))).then(Commands.literal((String)"rune").then(Commands.argument((String)"rune", (ArgumentType)new RuneArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.grantRune((Entity)player, RuneArgument.getRune(ctx, "rune"));
            }
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"remove").then(Commands.literal((String)"sign").then(Commands.argument((String)"sign", (ArgumentType)new SignArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.removeSign((Entity)player, SignArgument.getSign(ctx, "sign"));
            }
        }))))).then(Commands.literal((String)"fact").then(Commands.argument((String)"fact", (ArgumentType)ResourceLocationArgument.id()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.removeFact((Entity)player, ResourceLocationArgument.getId((CommandContext)ctx, (String)"fact"));
            }
        }))))).then(Commands.literal((String)"research").then(Commands.argument((String)"research", (ArgumentType)new ResearchArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.removeResearch((Entity)player, ResearchArgument.getResearch(ctx, "research").getRegistryName());
            }
        }))))).then(Commands.literal((String)"rune").then(Commands.argument((String)"rune", (ArgumentType)new RuneArgument()).executes(ctx -> KnowledgeCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            Object k = player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
            if (k != null) {
                KnowledgeUtil.removeRune((Entity)player, RuneArgument.getRune(ctx, "rune"));
            }
        })))))));
    }

    private static int apply(CommandSourceStack sources, Collection<? extends Player> players, BiConsumer<Player, CommandSourceStack> action) {
        for (Player player : players) {
            action.accept(player, sources);
        }
        if (players.size() == 1) {
            sources.sendSuccess(() -> Component.translatable((String)"commands.eidolon.knowledge.success.single", (Object[])new Object[]{((Player)players.iterator().next()).getDisplayName()}), true);
        } else {
            sources.sendSuccess(() -> Component.translatable((String)"commands.eidolon.knowledge.success.multiple", (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }

    public static class SignArgument
    implements ArgumentType<Sign> {
        private static final DynamicCommandExceptionType UNKNOWN = new DynamicCommandExceptionType(obj -> Component.translatable((String)"argument.eidolon.sign.unknown", (Object[])new Object[]{obj}));

        public static Sign getSign(CommandContext<?> context, String name) {
            return (Sign)context.getArgument(name, Sign.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (Sign s : Signs.getSigns()) {
                if (!s.getRegistryName().toString().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(s.getRegistryName().toString());
            }
            return builder.buildFuture();
        }

        public Sign parse(StringReader reader) throws CommandSyntaxException {
            ResourceLocation rl = ResourceLocation.read((StringReader)reader);
            Sign s = Signs.find(rl);
            if (s == null) {
                throw UNKNOWN.create((Object)rl.toString());
            }
            return s;
        }

        public static SignArgument signs() {
            return new SignArgument();
        }
    }

    public static class ResearchArgument
    implements ArgumentType<Research> {
        private static final DynamicCommandExceptionType UNKNOWN = new DynamicCommandExceptionType(obj -> Component.translatable((String)"argument.eidolon.research.unknown", (Object[])new Object[]{obj}));

        public static ResearchArgument researches() {
            return new ResearchArgument();
        }

        public static Research getResearch(CommandContext<?> context, String name) {
            return (Research)context.getArgument(name, Research.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (Research r : Researches.getResearches()) {
                if (!r.getRegistryName().toString().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(r.getRegistryName().toString());
            }
            return builder.buildFuture();
        }

        public Research parse(StringReader reader) throws CommandSyntaxException {
            ResourceLocation rl = ResourceLocation.read((StringReader)reader);
            Research r = Researches.find(rl);
            if (r == null) {
                throw UNKNOWN.create((Object)rl.toString());
            }
            return r;
        }
    }

    public static class RuneArgument
    implements ArgumentType<Rune> {
        private static final DynamicCommandExceptionType UNKNOWN = new DynamicCommandExceptionType(obj -> Component.translatable((String)"argument.eidolon.rune.unknown", (Object[])new Object[]{obj}));

        public static RuneArgument runes() {
            return new RuneArgument();
        }

        public static Rune getRune(CommandContext<?> context, String name) {
            return (Rune)context.getArgument(name, Rune.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (Rune r : Runes.getRunes()) {
                if (!r.getRegistryName().toString().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(r.getRegistryName().toString());
            }
            return builder.buildFuture();
        }

        public Rune parse(StringReader reader) throws CommandSyntaxException {
            ResourceLocation rl = ResourceLocation.read((StringReader)reader);
            Rune r = Runes.find(rl);
            if (r == null) {
                throw UNKNOWN.create((Object)rl.toString());
            }
            return r;
        }
    }
}

