/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.ritual;

import elucent.eidolon.api.ritual.IRequirement;
import elucent.eidolon.api.ritual.RequirementInfo;
import elucent.eidolon.util.ColorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;

public abstract class Ritual
implements Cloneable {
    ResourceLocation name = null;
    final int color;
    final ResourceLocation symbol;
    final List<IRequirement> stepRequirements = new ArrayList<IRequirement>();
    final List<IRequirement> continuousRequirements = new ArrayList<IRequirement>();

    public Ritual(ResourceLocation symbol, float r, float g, float b) {
        this.symbol = symbol;
        this.color = ColorUtil.packColor(255, (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public Ritual(ResourceLocation symbol, int color) {
        this.symbol = symbol;
        this.color = color;
    }

    public Ritual(ResourceLocation symbol, int color, ResourceLocation name) {
        this.symbol = symbol;
        this.color = color;
        this.name = name;
    }

    public ResourceLocation getSymbol() {
        return this.symbol;
    }

    public Component getName() {
        return Component.translatable((String)(this.getRegistryName().getNamespace() + ".ritual." + this.getRegistryName().getPath()));
    }

    public Ritual setRegistryName(String domain, String path) {
        this.name = ResourceLocation.fromNamespaceAndPath((String)domain, (String)path);
        return this;
    }

    public Ritual setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Ritual addRequirement(IRequirement requirement) {
        this.stepRequirements.add(requirement);
        return this;
    }

    public Ritual addRequirements(List<IRequirement> requirements) {
        this.stepRequirements.addAll(requirements);
        return this;
    }

    public void sortRequirements() {
        this.stepRequirements.sort((a, b) -> b.getPriority() - a.getPriority());
    }

    public Ritual addInvariant(IRequirement requirement) {
        this.continuousRequirements.add(requirement);
        return this;
    }

    public Ritual addInvariants(List<IRequirement> requirements) {
        this.continuousRequirements.addAll(requirements);
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public float getRed() {
        return (float)ColorUtil.getRed(this.color) / 255.0f;
    }

    public float getGreen() {
        return (float)ColorUtil.getGreen(this.color) / 255.0f;
    }

    public float getBlue() {
        return (float)ColorUtil.getBlue(this.color) / 255.0f;
    }

    public List<IRequirement> getRequirements() {
        return this.stepRequirements;
    }

    public List<IRequirement> getInvariants() {
        return this.continuousRequirements;
    }

    public Ritual clone() {
        return this.cloneRitual().addInvariants(this.getInvariants()).setRegistryName(this.getRegistryName());
    }

    public abstract Ritual cloneRitual();

    public SetupResult setup(Level world, BlockPos pos, int step) {
        if (step >= this.stepRequirements.size()) {
            return SetupResult.SUCCEED;
        }
        for (IRequirement req : this.continuousRequirements) {
            RequirementInfo info = req.isMet(this, world, pos);
            if (!info.isMet()) {
                return SetupResult.FAIL;
            }
            req.whenMet(this, world, pos, info);
        }
        IRequirement req = this.stepRequirements.get(step);
        RequirementInfo info = req.isMet(this, world, pos);
        if (!info.isMet()) {
            return SetupResult.FAIL;
        }
        req.whenMet(this, world, pos, info);
        return SetupResult.PASS;
    }

    public AABB getSearchBounds(BlockPos pos) {
        return Ritual.getDefaultBounds(pos);
    }

    public static AABB getDefaultBounds(BlockPos pos) {
        return new AABB((double)(pos.getX() - 8), (double)(pos.getY() - 6), (double)(pos.getZ() - 8), (double)(pos.getX() + 9), (double)(pos.getY() + 11), (double)(pos.getZ() + 9));
    }

    public RitualResult tick(Level world, BlockPos pos) {
        return RitualResult.PASS;
    }

    public RitualResult start(Level world, BlockPos pos) {
        return RitualResult.PASS;
    }

    public static <T> List<T> getTilesWithinAABB(Class<T> type, Level world, AABB bb) {
        ArrayList<T> tileList = new ArrayList<T>();
        for (int i = (int)Math.floor(bb.minX); i < (int)Math.ceil(bb.maxX) + 16; i += 16) {
            for (int j = (int)Math.floor(bb.minZ); j < (int)Math.ceil(bb.maxZ) + 16; j += 16) {
                ChunkAccess c = world.getChunk(new BlockPos(i, 0, j));
                Set tiles = c.getBlockEntitiesPos();
                for (BlockPos p : tiles) {
                    BlockEntity t;
                    if (!bb.contains((double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5) || !type.isInstance(t = world.getBlockEntity(p))) continue;
                    tileList.add(type.cast(t));
                }
            }
        }
        return tileList;
    }

    public static enum SetupResult {
        FAIL,
        PASS,
        SUCCEED;

    }

    public static enum RitualResult {
        PASS,
        TERMINATE;

    }
}

