/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.research;

import elucent.eidolon.mixin.AbstractContainerMenuMixin;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class ResearchTask {
    public abstract CompoundTag write(HolderLookup.Provider var1);

    public abstract void read(CompoundTag var1, HolderLookup.Provider var2);

    public abstract CompletenessResult isComplete(AbstractContainerMenu var1, Player var2, int var3);

    public abstract void onComplete(AbstractContainerMenu var1, Player var2, int var3);

    @OnlyIn(value=Dist.CLIENT)
    public abstract int getWidth();

    @OnlyIn(value=Dist.CLIENT)
    public abstract void drawIcon(GuiGraphics var1, ResourceLocation var2, int var3, int var4);

    @OnlyIn(value=Dist.CLIENT)
    public int drawCustom(@NotNull GuiGraphics stack, ResourceLocation texture, int x, int y) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDefaultWidth() {
        return 64;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTooltip(@NotNull GuiGraphics stack, AbstractContainerScreen<?> gui, double mouseX, double mouseY) {
    }

    public int getSlotCount() {
        return 0;
    }

    public void modifyContainer(AbstractContainerMenu menu, int x, int y) {
    }

    public static class XP
    extends ResearchTask {
        int levels;

        public XP(Random random) {
            this.levels = random.nextInt(1, 6);
        }

        public XP(int i) {
            this.levels = i;
        }

        @Override
        public CompoundTag write(HolderLookup.Provider registries) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("levels", this.levels);
            return tag;
        }

        @Override
        public void read(CompoundTag tag, HolderLookup.Provider registries) {
            this.levels = tag.getInt("levels");
        }

        @Override
        public int getWidth() {
            return this.getDefaultWidth();
        }

        @Override
        public void drawIcon(GuiGraphics stack, ResourceLocation texture, int x, int y) {
            int offY = Minecraft.getInstance().player.experienceLevel < this.levels ? 16 : 0;
            stack.blit(texture, x, y, 0, (float)((this.levels - 1) * 16), (float)(224 + offY), 16, 16, 256, 256);
        }

        @Override
        public CompletenessResult isComplete(AbstractContainerMenu menu, Player player, int slotStart) {
            return new CompletenessResult(slotStart, player.experienceLevel >= this.levels);
        }

        @Override
        public void drawTooltip(@NotNull GuiGraphics stack, AbstractContainerScreen<?> gui, double mouseX, double mouseY) {
            MutableComponent tooltip = this.levels == 1 ? Component.translatable((String)"container.enchant.level.one") : Component.translatable((String)"container.enchant.level.many", (Object[])new Object[]{this.levels});
            stack.renderTooltip(Minecraft.getInstance().font, (Component)tooltip, (int)mouseX, (int)mouseY);
        }

        @Override
        public void onComplete(AbstractContainerMenu menu, Player player, int slotStart) {
            player.giveExperienceLevels(-this.levels);
        }
    }

    public static class TaskItems
    extends ResearchTask {
        List<ItemStack> items;
        final InternalContainer container;

        public TaskItems(ItemStack ... stacks) {
            this.items = List.of(stacks);
            this.container = new InternalContainer();
        }

        public TaskItems(List<ItemStack> stacks) {
            this.items = stacks;
            this.container = new InternalContainer();
        }

        public static Function<Random, ResearchTask> fromTag(TagKey<Item> tagKey, int maxCount) {
            return random -> {
                List<ItemStack> items = List.of(Ingredient.of((TagKey)tagKey).getItems());
                for (ItemStack item : items) {
                    if (!item.isStackable()) continue;
                    item.setCount(random.nextInt(1, maxCount));
                }
                return new TaskItems(items.get(random.nextInt(items.size())));
            };
        }

        @Override
        public CompoundTag write(HolderLookup.Provider registries) {
            CompoundTag tag = new CompoundTag();
            tag.put("stacks", (Tag)new ListTag());
            return (CompoundTag)this.items.stream().map(s -> s.save(registries, (Tag)new CompoundTag())).reduce((Tag)tag, (t, s) -> {
                ((CompoundTag)t).getList("stacks", 10).add(s);
                return t;
            });
        }

        @Override
        public void read(CompoundTag tag, HolderLookup.Provider registries) {
            ListTag list = tag.getList("stacks", 10);
            for (Tag t : list) {
                this.items.add(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)((CompoundTag)t)));
            }
        }

        @Override
        public int getWidth() {
            return this.getDefaultWidth() + 8 + 17 * this.items.size();
        }

        @Override
        public void drawIcon(GuiGraphics stack, ResourceLocation texture, int x, int y) {
            int offset = (this.items.size() - 1) * -4;
            ItemRenderer ir = Minecraft.getInstance().getItemRenderer();
            for (int i = 0; i < this.items.size(); ++i) {
                stack.renderItem(this.items.get(i), x + i * 8 + offset, y);
                stack.renderItemDecorations(Minecraft.getInstance().font, this.items.get(i), x + i * 8 + offset, y, null);
            }
        }

        @Override
        public int drawCustom(@NotNull GuiGraphics guiGraphics, ResourceLocation texture, int x, int y) {
            guiGraphics.blit(texture, x, y, 0, 88.0f, 224.0f, 1, 32, 256, 256);
            ++x;
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.items.size() == 1) {
                    guiGraphics.blit(texture, x, y, 0, 192.0f, 0.0f, 22, 32, 256, 256);
                    x += 22;
                    continue;
                }
                if (i == 0) {
                    guiGraphics.blit(texture, x, y, 0, 192.0f, 32.0f, 20, 32, 256, 256);
                    x += 19;
                    continue;
                }
                if (i == this.items.size() - 1) {
                    guiGraphics.blit(texture, x, y, 0, 228.0f, 32.0f, 20, 32, 256, 256);
                    x += 20;
                    continue;
                }
                guiGraphics.blit(texture, x, y, 0, 211.0f, 32.0f, 18, 32, 256, 256);
                x += 17;
            }
            guiGraphics.blit(texture, x, y, 0, 88.0f, 224.0f, 2, 32, 256, 256);
            x += 2;
            return 8 + 17 * this.items.size();
        }

        @Override
        public void drawTooltip(@NotNull GuiGraphics stack, AbstractContainerScreen<?> gui, double mouseX, double mouseY) {
            List tooltip = Screen.getTooltipFromItem((Minecraft)gui.getMinecraft(), (ItemStack)this.items.getFirst());
            stack.renderComponentTooltip(Minecraft.getInstance().font, tooltip, (int)mouseX, (int)mouseY);
        }

        @Override
        public int getSlotCount() {
            return this.items.size();
        }

        @Override
        public void modifyContainer(AbstractContainerMenu menu, int x, int y) {
            for (int i = 0; i < this.items.size(); ++i) {
                final ItemStack stack = this.items.get(i);
                ((AbstractContainerMenuMixin)menu).callAddSlot(new Slot(this, this.container, i, x + 11 + 17 * i, y + 7){

                    public boolean mayPlace(@NotNull ItemStack pStack) {
                        return ItemStack.isSameItemSameComponents((ItemStack)pStack, (ItemStack)stack);
                    }
                });
            }
        }

        @Override
        public CompletenessResult isComplete(AbstractContainerMenu menu, Player player, int slotStart) {
            boolean isMatching = true;
            for (int i = 0; i < this.items.size() && isMatching; ++i) {
                if (menu.getItems().size() <= slotStart + i) {
                    isMatching = false;
                    continue;
                }
                ItemStack slot = menu.getSlot(slotStart + i).getItem();
                if (!ItemStack.isSameItemSameComponents((ItemStack)this.items.get(i), (ItemStack)slot)) {
                    isMatching = false;
                }
                if (slot.getCount() >= this.items.get(i).getCount()) continue;
                isMatching = false;
            }
            return new CompletenessResult(slotStart + this.items.size(), isMatching);
        }

        @Override
        public void onComplete(AbstractContainerMenu menu, Player player, int slotStart) {
            for (int i = 0; i < this.items.size(); ++i) {
                menu.getSlot(slotStart + i).remove(this.items.get(i).getCount());
            }
        }

        class InternalContainer
        implements Container {
            final List<ItemStack> items = new ArrayList<ItemStack>();

            InternalContainer() {
            }

            protected void updateItems() {
                while (this.items.size() < TaskItems.this.items.size()) {
                    this.items.add(ItemStack.EMPTY);
                }
            }

            public void clearContent() {
                this.items.clear();
            }

            public int getContainerSize() {
                return TaskItems.this.items.size();
            }

            public boolean isEmpty() {
                for (ItemStack s : this.items) {
                    if (s.isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @NotNull
            public ItemStack getItem(int slot) {
                this.updateItems();
                return this.items.get(slot);
            }

            @NotNull
            public ItemStack removeItem(int slot, int amount) {
                this.updateItems();
                ItemStack stack = ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
                if (!stack.isEmpty()) {
                    this.setChanged();
                }
                return stack;
            }

            @NotNull
            public ItemStack removeItemNoUpdate(int slot) {
                this.updateItems();
                ItemStack itemstack = this.items.get(slot);
                if (itemstack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                this.items.set(slot, ItemStack.EMPTY);
                return itemstack;
            }

            public void setItem(int slot, @NotNull ItemStack stack) {
                this.updateItems();
                this.items.set(slot, stack);
            }

            public void setChanged() {
            }

            public boolean stillValid(@NotNull Player p_18946_) {
                return true;
            }
        }
    }

    public record CompletenessResult(int nextSlot, boolean complete) {
    }
}

