/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.research;

import elucent.eidolon.api.research.ResearchTask;
import elucent.eidolon.registries.Researches;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class Research {
    final ResourceLocation rl;
    final int stars;
    final Map<Integer, List<ResearchTask>> specialTasks = new HashMap<Integer, List<ResearchTask>>();

    public Research(ResourceLocation rl, int stars) {
        this.rl = rl;
        this.stars = stars;
        if (stars <= 0) {
            throw new IllegalArgumentException("Research difficulty must be at least one star!");
        }
        if (stars > 10) {
            throw new IllegalArgumentException("Research difficulty cannot exceed ten stars!");
        }
    }

    public Research addSpecialTasks(int step, ResearchTask ... tasks) {
        this.specialTasks.put(step, List.of(tasks));
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.rl;
    }

    public int getStars() {
        return this.stars;
    }

    public String getName() {
        return Component.translatable((String)("research." + this.rl.getNamespace() + "." + this.rl.getPath())).getString();
    }

    public List<ResearchTask> getTasks(int rootSeed, int done) {
        if (this.specialTasks.containsKey(done)) {
            return this.specialTasks.get(done);
        }
        ArrayList<ResearchTask> tasks = new ArrayList<ResearchTask>();
        int seed = this.getSeed(rootSeed, done);
        Random random = new Random(seed);
        for (int i = 0; i < 3; ++i) {
            tasks.add(Researches.getRandomTask(random));
        }
        return tasks;
    }

    public int getSeed(int rootSeed, int done) {
        return this.rl.hashCode() * 384780223 ^ done * 844955129 ^ rootSeed * 112041199 + 6;
    }

    public void onLearned(ServerPlayer serverPlayer) {
    }
}

