/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.capability;

import elucent.eidolon.registries.EidolonAttributes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;

public interface ISoul {
    public boolean hasEtherealHealth();

    public float getMaxEtherealHealth();

    public float getEtherealHealth();

    public void setEtherealHealth(float var1);

    public void setMaxEtherealHealth(float var1);

    default public float hurtEtherealHealth(float amount, float persistentHealth) {
        amount = Math.max(0.0f, amount);
        float oldHealth = this.getEtherealHealth();
        this.setMaxEtherealHealth(Math.max(this.getMaxEtherealHealth() - amount, Math.min(persistentHealth, this.getMaxEtherealHealth())));
        this.setEtherealHealth(oldHealth - amount);
        return Math.max(0.0f, amount - oldHealth);
    }

    default public void healEtherealHealth(float amount, float persistentHealth) {
        amount = Math.max(0.0f, amount);
        this.setEtherealHealth(Math.min(Math.max(this.getEtherealHealth(), persistentHealth), this.getEtherealHealth() + amount));
    }

    public static float getPersistentHealth(LivingEntity entity) {
        AttributeInstance attr = entity.getAttribute(EidolonAttributes.PERSISTENT_SOUL_HEARTS);
        if (attr != null) {
            return (float)attr.getValue();
        }
        return 0.0f;
    }
}

