package elucent.eidolon.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

import static elucent.eidolon.codex.CodexGui.blit;

public class CancelButton extends Button {
    protected CancelButton(int pX, int pY, int pWidth, int pHeight, OnPress pOnPress) {
        super(pX, pY, pWidth, pHeight, Component.empty(), pOnPress, Button.DEFAULT_NARRATION);
    }

    @Override
    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        blit(pGuiGraphics, getX(), getY() - 4, 368, isHovered ? 240 : 208, 32, 32, 512, 512);
        if (isHovered)
            pGuiGraphics.renderTooltip(Minecraft.getInstance().font, Component.translatable("eidolon.codex.cancel_hover"), pMouseX, pMouseY);

    }

}
