package elucent.eidolon.codex;

import elucent.eidolon.Eidolon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class TitlePage extends Page {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath(Eidolon.MODID,"textures/gui/codex_title_page.png" );
    final String text;
    final String title;
    ItemStack reference = ItemStack.EMPTY;

    public TitlePage(String textKey) {
        super(BACKGROUND);
        this.text = textKey;
        this.title = textKey + ".title";
    }

    public TitlePage(String textKey, String titleKey) {
        super(BACKGROUND);
        this.text = textKey;
        this.title = titleKey;
    }

    public TitlePage(String textKey, ItemStack reference) {
        super(BACKGROUND);
        this.text = textKey;
        this.title = reference.getDescriptionId();
        this.reference = reference;
    }

    @Override
    @OnlyIn(Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics mStack, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        String title = I18n.get(this.title);
        int titleWidth = Minecraft.getInstance().font.width(title);
        drawText(mStack, title, x + 64 - titleWidth / 2, y + 15 - Minecraft.getInstance().font.lineHeight);
        drawWrappingText(mStack, I18n.get(text), x + 4, y + 24, 120);
    }
}
