package elucent.eidolon.codex;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import elucent.eidolon.Eidolon;
import elucent.eidolon.util.ColorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

import java.util.ArrayList;
import java.util.List;

public abstract class Page {
    final ResourceLocation bg;

    public Page(ResourceLocation background) {
        this.bg = background;
    }

    public void reset() {
        //
    }

    @OnlyIn(Dist.CLIENT)
    public static void drawItem(GuiGraphics guiGraphics, ItemStack stack, int x, int y, int mouseX, int mouseY) {
        guiGraphics.renderItem(stack, x, y);
        var font = Minecraft.getInstance().font;
        guiGraphics.renderItemDecorations(font, stack, x, y, null);
        if (mouseX >= x && mouseY >= y && mouseX <= x + 16 && mouseY <= y + 16) {
            guiGraphics.renderTooltip(font, stack, mouseX, mouseY);
        }
    }

    @OnlyIn(Dist.CLIENT)
    public static void drawItems(GuiGraphics guiGraphics, Ingredient ingredient, int x, int y, int mouseX, int mouseY) {
        if (ingredient.isEmpty()) return;
        ItemStack[] items = ingredient.getItems();
        ItemStack stack = items[((int) Eidolon.proxy.getWorld().getGameTime() / 20) % items.length];
        drawItem(guiGraphics, stack, x, y, mouseX, mouseY);
    }

    @OnlyIn(Dist.CLIENT)
    public static void drawText(GuiGraphics guiGraphics, String text, int x, int y) {
        Font font = Minecraft.getInstance().font;
        guiGraphics.drawString(font, text, x, y - 1, ColorUtil.packColor(128, 255, 255, 255), false);
        guiGraphics.drawString(font, text, x - 1, y, ColorUtil.packColor(128, 219, 212, 184), false);
        guiGraphics.drawString(font, text, x + 1, y, ColorUtil.packColor(128, 219, 212, 184), false);
        guiGraphics.drawString(font, text, x, y + 1, ColorUtil.packColor(128, 191, 179, 138), false);
        guiGraphics.drawString(font, text, x, y, ColorUtil.packColor(255, 79, 59, 47), false);
    }

    public static List<String> wrapTextToLines(String text, int maxWidth) {
        Font font = Minecraft.getInstance().font;
        List<String> lines = new ArrayList<>();
        String[] words = text.split(" ");
        String line = "";

        for (String word : words) {
            if (font.width(line) + font.width(word) > maxWidth) {
                lines.add(line.trim());  // Trim the trailing space
                line = word + " ";
            } else {
                line += word + " ";
            }
        }

        // Add the final line if it exists
        if (!line.isEmpty()) {
            lines.add(line.trim());
        }

        return lines;
    }


    @OnlyIn(Dist.CLIENT)
    public static void drawWrappingText(GuiGraphics mStack, String text, int x, int y, int w) {
        Font font = Minecraft.getInstance().font;

        // Split text into sentences first (to handle punctuation-based breaks)
        String[] sentences = text.split("(?<=[.!?])\\s+");

        // Now, wrap each sentence to fit within the specified width (w)
        List<String> wrappedLines = new ArrayList<>();
        for (String sentence : sentences) {
            List<String> sentenceLines = wrapTextToLines(sentence, w);
            wrappedLines.addAll(sentenceLines);
        }

        // Now, render the wrapped lines
        for (int i = 0; i < wrappedLines.size(); i++) {
            drawText(mStack, wrappedLines.get(i), x, y + i * (font.lineHeight + 1));  // Add some padding between lines
        }
    }


    @OnlyIn(Dist.CLIENT)
    public void fullRender(CodexGui gui, GuiGraphics mStack, int x, int y, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture(0, bg);
        renderBackground(mStack, x, y, mouseX, mouseY);
        render(gui, mStack, bg, x, y, mouseX, mouseY);
        renderIngredients(gui, mStack, x, y, mouseX, mouseY);
    }

    @OnlyIn(Dist.CLIENT)
    public void renderBackground(@NotNull GuiGraphics mStack, int x, int y, int mouseX, int mouseY) {
        mStack.blit(bg, x, y, 0, 0, 128, 160);
    }

    @OnlyIn(Dist.CLIENT)
    public boolean click(CodexGui gui, int x, int y, int mouseX, int mouseY) {
        return false;
    }

    @OnlyIn(Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics mStack, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
    }

    @OnlyIn(Dist.CLIENT)
    public void renderIngredients(CodexGui gui, GuiGraphics mStack, int x, int y, int mouseX, int mouseY) {
    }

    @OnlyIn(Dist.CLIENT)
    public static void colorBlit(PoseStack mStack, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight, int color) {
        Matrix4f matrix = mStack.last().pose();
        int maxX = x + width, maxY = y + height;
        float minU = (float) uOffset / textureWidth, minV = (float) vOffset / textureHeight;
        float maxU = minU + (float) width / textureWidth, maxV = minV + (float) height / textureHeight;
        int r = ColorUtil.getRed(color),
                g = ColorUtil.getGreen(color),
                b = ColorUtil.getBlue(color);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix, (float) x, (float) maxY, 0).setUv(minU, maxV).setColor(r, g, b, 255);
        bufferbuilder.addVertex(matrix, (float) maxX, (float) maxY, 0).setUv(maxU, maxV).setColor(r, g, b, 255);
        bufferbuilder.addVertex(matrix, (float) maxX, (float) y, 0).setUv(maxU, minV).setColor(r, g, b, 255);
        bufferbuilder.addVertex(matrix, (float) x, (float) y, 0).setUv(minU, minV).setColor(r, g, b, 255);
        BufferUploader.drawWithShader(bufferbuilder.build());
    }
}
