/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_hex.malum;

import com.alexthw.ars_hex.malum.EnchanterScythe;
import com.alexthw.ars_hex.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.common.event.ReactiveEvents;
import com.hollingsworth.arsnouveau.common.light.LightManager;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import com.sammy.malum.common.entity.scythe.ScytheBoomerangEntity;
import com.sammy.malum.registry.common.entity.MalumEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;

public class MalumCompat {
    public static DeferredHolder<Item, ? extends Item> ENCHANTER_SCYTHE;

    public static void postInit() {
        LightManager.register((EntityType)((EntityType)MalumEntities.NATURAL_SPIRIT.get()), p -> 8);
        LightManager.register((EntityType)((EntityType)MalumEntities.ETHERIC_NITRATE.get()), p -> 15);
        LightManager.register((EntityType)((EntityType)MalumEntities.VIVID_NITRATE.get()), p -> 15);
    }

    public static void init() {
        NeoForge.EVENT_BUS.register(MalumCompat.class);
        ENCHANTER_SCYTHE = ModRegistry.ITEMS.register("enchanter_scythe", () -> new EnchanterScythe((Tier)Tiers.NETHERITE, -4.0f, 0.0f, 3.0f, new LodestoneItemProperties().stacksTo(1)));
    }

    @SubscribeEvent
    public static void workaround(LivingDamageEvent.Post event) {
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof ScytheBoomerangEntity) {
            ScytheBoomerangEntity scytheBoomerang = (ScytheBoomerangEntity)entity;
            if (scytheBoomerang.getItem().getItem() instanceof ICasterTool && (entity = scytheBoomerang.getOwner()) instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                scytheBoomerang.getItem().getItem().hurtEnemy(scytheBoomerang.getItem(), event.getEntity(), owner);
            } else {
                LivingEntity living;
                entity = event.getSource().getEntity();
                if (entity instanceof LivingEntity && (living = (LivingEntity)entity).level().holder(EnchantmentRegistry.REACTIVE_ENCHANTMENT).isPresent() && scytheBoomerang.getItem().getEnchantmentLevel(living.level().holderOrThrow(EnchantmentRegistry.REACTIVE_ENCHANTMENT)) > 0) {
                    ReactiveEvents.castSpell((LivingEntity)living, (ItemStack)scytheBoomerang.getItem());
                }
            }
        }
    }

    public static void initDocs() {
    }
}

