/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_hex.hexerei.broom;

import com.alexthw.ars_hex.ArsHex;
import com.alexthw.ars_hex.hexerei.HexereiModels;
import com.alexthw.ars_hex.hexerei.broom.EnchanterBroomEntity;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomStickBaseModel;
import net.joefoxe.hexerei.config.ModKeyBindings;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ArchwoodBroomStick
extends BroomItem
implements ICasterTool {
    String woodType;

    public ArchwoodBroomStick(String woodType, Item.Properties properties) {
        super(woodType, properties);
        this.woodType = woodType;
    }

    public BroomEntity getBroom(Level world, ItemStack stack, Vec3 pos) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        EnchanterBroomEntity broom = new EnchanterBroomEntity(world, pos.x, pos.y, pos.z);
        if (tag.contains("floatMode")) {
            broom.itemHandler.deserializeNBT((HolderLookup.Provider)world.registryAccess(), tag.getCompound("Inventory"));
        } else {
            broom.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)ModItems.BROOM_BRUSH.get()));
        }
        Item var6 = stack.getItem();
        if (var6 instanceof ArchwoodBroomStick) {
            ArchwoodBroomStick broomItem = (ArchwoodBroomStick)var6;
            broom.setBroomType(broomItem.woodType);
        }
        broom.isItem = true;
        broom.selfItem = stack.copy();
        if (stack.get(DataComponents.CUSTOM_NAME) != null) {
            broom.setCustomName(stack.getHoverName());
        }
        if (stack.get((Supplier)DataComponentRegistry.SPELL_CASTER) != null) {
            broom.setSpellCaster((SpellCaster)stack.get((Supplier)DataComponentRegistry.SPELL_CASTER));
        }
        return broom;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bakeModels() {
        EntityModelSet context = Minecraft.getInstance().getEntityModels();
        this.model = new HexereiModels.ArchwoodStick(context.bakeLayer(HexereiModels.ArchwoodStick.LAYER_LOCATION));
        this.outter_model = new BroomStickBaseModel(context.bakeLayer(BroomStickBaseModel.POWER_LAYER_LOCATION));
        this.texture = ArsHex.prefix("textures/entity/archwood_broom_stick.png");
        this.dye_texture = ArsHex.prefix("textures/entity/archwood_broom_stick.png");
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        AbstractCaster abstractCaster = SpellCasterRegistry.from((ItemStack)stack);
        if (abstractCaster instanceof SpellCaster) {
            SpellCaster caster = (SpellCaster)abstractCaster;
            if (!caster.getSpell().isEmpty()) {
                tooltip2.add((Component)Component.translatable((String)"tooltip.hexerei.key_for_spell", (Object[])new Object[]{ModKeyBindings.broomActivate.getTranslatedKeyMessage()}));
            }
            if (Screen.hasShiftDown() || !((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue()) {
                this.getInformation(stack, context, tooltip2, flagIn);
            }
        }
        super.appendHoverText(stack, context, tooltip2, flagIn);
    }

    public void onActivate(BroomEntity broom, RandomSource random) {
        Entity entity;
        EnchanterBroomEntity enchanterBroomEntity;
        super.onActivate(broom, random);
        if (broom instanceof EnchanterBroomEntity && (enchanterBroomEntity = (EnchanterBroomEntity)broom).getSpellCaster() != null && (entity = broom.getFirstPassenger()) instanceof Player) {
            Player playerIn = (Player)entity;
            enchanterBroomEntity.getSpellCaster().castSpell(playerIn.getCommandSenderWorld(), (LivingEntity)playerIn, InteractionHand.MAIN_HAND, null);
        }
    }
}

