package com.alexthw.ars_hex.datagen;

import com.alexthw.ars_hex.ArsHex;
import com.alexthw.ars_hex.hexerei.HexereiCompat;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import net.joefoxe.hexerei.util.HexereiTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.ItemTagsProvider;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.CompletableFuture;

public class AHItemTagProvider extends ItemTagsProvider {

    public AHItemTagProvider(DataGenerator pGenerator, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper, BlockTagsProvider blockTagsProvider) {
        super(pGenerator.getPackOutput(), lookupProvider, blockTagsProvider.contentsGetter(), ArsHex.MODID, existingFileHelper);
    }

    @Override
    protected void addTags(HolderLookup.@NotNull Provider provider) {
        tag(HexereiTags.Items.BROOM_BRUSH).addOptional(HexereiCompat.MAGEBLOOM_BRUSH.getId());
        tag(ItemTagProvider.SHARD_TAG);
    }

    @Override
    public @NotNull String getName() {
        return "Ars Hex Item Tags";
    }

}

class AHBlockTagsProvider extends BlockTagsProvider {

    public AHBlockTagsProvider(DataGenerator gen, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
        super(gen.getPackOutput(), provider, ArsHex.MODID, existingFileHelper);
    }

    @Override
    protected void addTags(HolderLookup.@NotNull Provider provider) {
        // add tags here
    }

}