/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_hex.iss;

import com.alexthw.ars_hex.iss.ElementalModule;
import com.alexthw.ars_hex.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.particle.PropertyParticleType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.client.particle.WrappedProvider;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.mojang.datafixers.util.Pair;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.particle.ElectricityParticle;
import io.redspace.ironsspellbooks.particle.FireParticle;
import io.redspace.ironsspellbooks.particle.FireflyParticle;
import io.redspace.ironsspellbooks.particle.SnowflakeParticle;
import io.redspace.ironsspellbooks.particle.WispParticle;
import io.redspace.ironsspellbooks.registries.ParticleRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ISSCompat {
    public static Map<SpellSchool, SchoolType> schoolToSchoolMap = new HashMap<SpellSchool, SchoolType>();
    public static Map<SchoolType, Pair<Holder<Attribute>, Holder<Attribute>>> schoolAttributes = new HashMap<SchoolType, Pair<Holder<Attribute>, Holder<Attribute>>>();
    public static DeferredHolder<ParticleType<?>, PropertyParticleType> WISP_PARTICLE;
    public static DeferredHolder<ParticleType<?>, PropertyParticleType> SNOWFLAKE_PARTICLE;
    public static DeferredHolder<ParticleType<?>, PropertyParticleType> ELECTRICITY_PARTICLE;
    public static DeferredHolder<ParticleType<?>, PropertyParticleType> FIRE_PARTICLE;
    public static DeferredHolder<ParticleType<?>, PropertyParticleType> FIREFLY_PARTICLE;

    public static void init(IEventBus modEventBus) {
        WISP_PARTICLE = ModRegistry.PARTICLES.register("wisp_iss", PropertyParticleType::new);
        SNOWFLAKE_PARTICLE = ModRegistry.PARTICLES.register("snowflake_iss", PropertyParticleType::new);
        ELECTRICITY_PARTICLE = ModRegistry.PARTICLES.register("electricity_iss", PropertyParticleType::new);
        FIRE_PARTICLE = ModRegistry.PARTICLES.register("fire_iss", PropertyParticleType::new);
        FIREFLY_PARTICLE = ModRegistry.PARTICLES.register("firefly_iss", PropertyParticleType::new);
    }

    public static void postInit() {
        schoolToSchoolMap.put(SpellSchools.ELEMENTAL_EARTH, (SchoolType)SchoolRegistry.NATURE.get());
        schoolToSchoolMap.put(SpellSchools.ELEMENTAL_FIRE, (SchoolType)SchoolRegistry.FIRE.get());
        schoolToSchoolMap.put(SpellSchools.ELEMENTAL_WATER, (SchoolType)SchoolRegistry.ICE.get());
        schoolToSchoolMap.put(SpellSchools.ELEMENTAL_AIR, (SchoolType)SchoolRegistry.LIGHTNING.get());
        schoolToSchoolMap.put(SpellSchools.CONJURATION, (SchoolType)SchoolRegistry.EVOCATION.get());
        schoolAttributes.put((SchoolType)SchoolRegistry.NATURE.get(), (Pair<Holder<Attribute>, Holder<Attribute>>)Pair.of((Object)AttributeRegistry.NATURE_SPELL_POWER, (Object)AttributeRegistry.NATURE_MAGIC_RESIST));
        schoolAttributes.put((SchoolType)SchoolRegistry.FIRE.get(), (Pair<Holder<Attribute>, Holder<Attribute>>)Pair.of((Object)AttributeRegistry.FIRE_SPELL_POWER, (Object)AttributeRegistry.FIRE_MAGIC_RESIST));
        schoolAttributes.put((SchoolType)SchoolRegistry.ICE.get(), (Pair<Holder<Attribute>, Holder<Attribute>>)Pair.of((Object)AttributeRegistry.ICE_SPELL_POWER, (Object)AttributeRegistry.ICE_MAGIC_RESIST));
        schoolAttributes.put((SchoolType)SchoolRegistry.LIGHTNING.get(), (Pair<Holder<Attribute>, Holder<Attribute>>)Pair.of((Object)AttributeRegistry.LIGHTNING_SPELL_POWER, (Object)AttributeRegistry.LIGHTNING_MAGIC_RESIST));
        ParticleTypeProperty.addType((ParticleTypeProperty.ParticleData)new ParticleTypeProperty.ParticleData((ParticleType)WISP_PARTICLE.get(), true));
        ParticleTypeProperty.addType((ParticleTypeProperty.ParticleData)new ParticleTypeProperty.ParticleData((ParticleType)SNOWFLAKE_PARTICLE.get(), true));
        ParticleTypeProperty.addType((ParticleTypeProperty.ParticleData)new ParticleTypeProperty.ParticleData((ParticleType)ELECTRICITY_PARTICLE.get(), true));
        ParticleTypeProperty.addType((ParticleTypeProperty.ParticleData)new ParticleTypeProperty.ParticleData((ParticleType)FIRE_PARTICLE.get(), true));
        ParticleTypeProperty.addType((ParticleTypeProperty.ParticleData)new ParticleTypeProperty.ParticleData((ParticleType)FIREFLY_PARTICLE.get(), false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)WISP_PARTICLE.get(), sprites -> new WrappedProvider((SimpleParticleType)ParticleRegistry.WISP_PARTICLE.get(), WispParticle.Provider::new));
        event.registerSpriteSet((ParticleType)SNOWFLAKE_PARTICLE.get(), sprites -> new WrappedProvider((SimpleParticleType)ParticleRegistry.SNOWFLAKE_PARTICLE.get(), SnowflakeParticle.Provider::new));
        event.registerSpriteSet((ParticleType)ELECTRICITY_PARTICLE.get(), sprites -> new WrappedProvider((SimpleParticleType)ParticleRegistry.ELECTRICITY_PARTICLE.get(), ElectricityParticle.Provider::new));
        event.registerSpriteSet((ParticleType)FIRE_PARTICLE.get(), sprites -> new WrappedProvider((SimpleParticleType)ParticleRegistry.FIRE_PARTICLE.get(), FireParticle.Provider::new));
        event.registerSpriteSet((ParticleType)FIREFLY_PARTICLE.get(), sprites -> new WrappedProvider((SimpleParticleType)ParticleRegistry.FIREFLY_PARTICLE.get(), FireflyParticle.Provider::new));
    }

    public static void damageTweaksArs(SpellDamageEvent.Pre event) {
        LivingEntity living;
        block4: {
            block3: {
                Entity entity = event.target;
                if (!(entity instanceof LivingEntity)) break block3;
                living = (LivingEntity)entity;
                if (event.context.getCurrentIndex() > 0) break block4;
            }
            return;
        }
        AbstractSpellPart part = event.context.getSpell().get(event.context.getCurrentIndex() - 1);
        List schools = part.spellSchools;
        for (SpellSchool school : schools) {
            if (schoolToSchoolMap.get(school) == null) continue;
            SchoolType type = schoolToSchoolMap.get(school);
            double damageBuff = type.getPowerFor(event.caster);
            double damageRes = type.getResistanceFor(living);
            event.damage = (float)((double)event.damage * (1.0 + damageBuff - damageRes));
        }
    }

    public static void damageTweaksEISS(ItemAttributeModifierEvent event) {
        if (event.getItemStack().getItem() instanceof AnimatedMagicArmor && ModList.get().isLoaded("ars_elemental")) {
            ElementalModule.addArmorModifiers(event);
        }
    }

    public static void initDocs() {
    }
}

