/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.mixin;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.entity.spells.FlashLightning;
import alexthw.ars_elemental.datagen.AETagsProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Shadow
    protected abstract BlockPos findLightningTargetAround(BlockPos var1);

    @Inject(at={@At(value="HEAD")}, method={"tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V"})
    public void tickChunk(LevelChunk pChunk, int pRandomTickSpeed, CallbackInfo ci) {
        BlockPos blockpos;
        Holder biome;
        if (!((Boolean)ConfigHandler.Common.LIGHTNINGS_BIOME.get()).booleanValue()) {
            return;
        }
        Level level = pChunk.getLevel();
        if (level == null || level.isClientSide) {
            return;
        }
        ChunkPos chunkpos = pChunk.getPos();
        int x = chunkpos.getMinBlockX();
        int z = chunkpos.getMinBlockZ();
        if (level.random.nextInt(1000) == 0 && level.isRainingAt(new BlockPos(x, 120, z)) && (biome = pChunk.getLevel().getBiomeManager().getBiome(new BlockPos(x, 120, z))).is(AETagsProvider.AEBiomeTagsProvider.FLASHING_BIOME) && (blockpos = this.findLightningTargetAround(level.getBlockRandomPos(x, 0, z, 15))) != null) {
            FlashLightning lightning = new FlashLightning(level);
            lightning.moveTo(Vec3.atBottomCenterOf((Vec3i)blockpos));
            lightning.setVisualOnly(false);
            level.addFreshEntity((Entity)lightning);
        }
    }
}

