/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.common.items.armor.ShockPerk;
import alexthw.ars_elemental.common.items.armor.SporePerk;
import alexthw.ars_elemental.common.items.armor.SummonPerk;
import alexthw.ars_elemental.datagen.AETagsProvider;
import alexthw.ars_elemental.recipe.ElementalArmorRecipe;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.datagen.RecipeDatagen;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class AEApparatusProvider
extends ApparatusRecipeProvider {
    public AEApparatusProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        this.recipes.add(this.builder().withResult((ItemLike)this.getPerkItem(ShockPerk.INSTANCE.getRegistryName())).withReagent((ItemLike)ItemsRegistry.BLANK_THREAD).withPedestalItem(2, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(1, (ItemLike)Items.LIGHTNING_ROD).withPedestalItem(1, (ItemLike)ModItems.FLASHING_POD.get()).build());
        this.recipes.add(this.builder().withResult((ItemLike)this.getPerkItem(SporePerk.INSTANCE.getRegistryName())).withReagent((ItemLike)ItemsRegistry.BLANK_THREAD).withPedestalItem(2, (ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem(1, (ItemLike)Items.SPORE_BLOSSOM).withPedestalItem(1, (ItemLike)Items.SPIDER_EYE).build());
        this.recipes.add(this.builder().withResult((ItemLike)this.getPerkItem(SummonPerk.INSTANCE.getRegistryName())).withReagent((ItemLike)ItemsRegistry.BLANK_THREAD).withPedestalItem(2, (ItemLike)ItemsRegistry.CONJURATION_ESSENCE).withPedestalItem(1, (ItemLike)Items.ECHO_SHARD).withPedestalItem(2, Ingredient.of((TagKey)ItemTagProvider.WILDEN_DROP_TAG)).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.NECRO_FOCUS.get()).withReagent((ItemLike)ItemsRegistry.SUMMONING_FOCUS).withPedestalItem(2, (ItemLike)Items.WITHER_ROSE).withPedestalItem(1, (ItemLike)Items.WITHER_SKELETON_SKULL).withPedestalItem(1, (ItemLike)ModItems.ANIMA_ESSENCE.get()).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.WATER_UPSTREAM_BLOCK.get()).withReagent((ItemLike)Items.SOUL_SAND).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem(4, (ItemLike)Items.PRISMARINE_SHARD).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.LAVA_UPSTREAM_BLOCK.get()).withReagent((ItemLike)Items.SOUL_SAND).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem(4, (ItemLike)Items.MAGMA_BLOCK).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.AIR_UPSTREAM_BLOCK.get()).withReagent((ItemLike)Items.GOLD_BLOCK).withPedestalItem(4, (ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.WILDEN_WING).withPedestalItem(2, (ItemLike)Items.SHULKER_SHELL).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.WATER_URN.get()).withReagent((ItemLike)Blocks.FLOWER_POT).withPedestalItem(RecipeDatagen.SOURCE_GEM).withPedestalItem(2, (ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem(2, (ItemLike)Items.PRISMARINE_SHARD).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.SIREN_CHARM.get()).withReagent((ItemLike)ModItems.SIREN_SHARDS.get()).withPedestalItem((ItemLike)Items.PRISMARINE_SHARD).withPedestalItem(3, Ingredient.of((TagKey)ItemTags.FISHES)).withPedestalItem(3, RecipeDatagen.SOURCE_GEM).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.FIRENANDO_CHARM.get()).withReagent((ItemLike)Items.MAGMA_BLOCK).withPedestalItem(2, (ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)Items.NETHERITE_SCRAP).withPedestalItem(2, (ItemLike)Items.NETHER_BRICK).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.SPELL_HORN.get()).withReagent((ItemLike)ItemsRegistry.WILDEN_HORN).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem(3, (ItemLike)Items.GOLD_INGOT).withPedestalItem(4, RecipeDatagen.SOURCE_GEM).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.ENCHANTER_BANGLE.get()).withReagent((ItemLike)ItemsRegistry.RING_OF_POTENTIAL).withPedestalItem(RecipeDatagen.SOURCE_GEM_BLOCK).withPedestalItem((ItemLike)Items.GOLD_BLOCK).withPedestalItem((ItemLike)Items.GOLD_BLOCK).withPedestalItem((ItemLike)Items.END_CRYSTAL).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.AIR_BANGLE.get()).withReagent((ItemLike)ModItems.ENCHANTER_BANGLE.get()).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)Items.PISTON).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.FIRE_BANGLE.get()).withReagent((ItemLike)ModItems.ENCHANTER_BANGLE.get()).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)Items.FIRE_CHARGE).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.EARTH_BANGLE.get()).withReagent((ItemLike)ModItems.ENCHANTER_BANGLE.get()).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)Items.COBWEB).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.WATER_BANGLE.get()).withReagent((ItemLike)ModItems.ENCHANTER_BANGLE.get()).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem((ItemLike)Items.POWDER_SNOW_BUCKET).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.SUMMON_BANGLE.get()).withReagent((ItemLike)ModItems.ENCHANTER_BANGLE.get()).withPedestalItem((ItemLike)ItemsRegistry.CONJURATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.CONJURATION_ESSENCE).withPedestalItem((ItemLike)Items.BONE).withPedestalItem((ItemLike)ItemsRegistry.WILDEN_HORN).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.ANIMA_BANGLE.get()).withReagent((ItemLike)ModItems.ENCHANTER_BANGLE.get()).withPedestalItem((ItemLike)ModItems.ANIMA_ESSENCE.get()).withPedestalItem((ItemLike)ModItems.ANIMA_ESSENCE.get()).withPedestalItem((ItemLike)Items.GHAST_TEAR).withPedestalItem((ItemLike)Items.WITHER_ROSE).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.FIRE_FOCUS.get()).withReagent((ItemLike)ModItems.LESSER_FIRE_FOCUS.get()).withPedestalItem((ItemLike)ModItems.MARK_OF_MASTERY.get()).withSourceCost(5000).keepNbtOfReagent(true).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.AIR_FOCUS.get()).withReagent((ItemLike)ModItems.LESSER_AIR_FOCUS.get()).withPedestalItem((ItemLike)ModItems.MARK_OF_MASTERY.get()).withSourceCost(5000).keepNbtOfReagent(true).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.EARTH_FOCUS.get()).withReagent((ItemLike)ModItems.LESSER_EARTH_FOCUS.get()).withPedestalItem((ItemLike)ModItems.MARK_OF_MASTERY.get()).withSourceCost(5000).keepNbtOfReagent(true).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.WATER_FOCUS.get()).withReagent((ItemLike)ModItems.LESSER_WATER_FOCUS.get()).withPedestalItem((ItemLike)ModItems.MARK_OF_MASTERY.get()).withSourceCost(5000).keepNbtOfReagent(true).build());
        this.recipes.add(this.builder().withResult(new ItemStack((ItemLike)ModItems.SPELL_MIRROR.get(), 2)).withReagent(RecipeDatagen.SOURCE_GEM_BLOCK).withPedestalItem(2, RecipeDatagen.ARCHWOOD_LOG).withPedestalItem(2, Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ)).withPedestalItem(2, (ItemLike)Items.GOLD_INGOT).build());
        this.recipes.add(this.builder().withPedestalItem((ItemLike)BlockRegistry.SPELL_PRISM).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.ABJURATION_ESSENCE).buildEnchantmentRecipe(ModRegistry.MIRROR, 1, 2000));
        this.recipes.add(this.builder().withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem((ItemLike)ModItems.SPELL_MIRROR.get()).buildEnchantmentRecipe(ModRegistry.MIRROR, 2, 5000));
        this.recipes.add(this.builder().withPedestalItem((ItemLike)ItemsRegistry.ENCHANTERS_MIRROR).withPedestalItem((ItemLike)Items.TOTEM_OF_UNDYING).withPedestalItem(RecipeDatagen.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(ModRegistry.MIRROR, 3, 8000));
        this.recipes.add(this.builder().withPedestalItem((ItemLike)ModItems.ANIMA_ESSENCE.get()).withPedestalItem((ItemLike)Items.TOTEM_OF_UNDYING).withPedestalItem((ItemLike)Blocks.LAPIS_BLOCK).withPedestalItem(RecipeDatagen.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(ModRegistry.SOULBOUND, 1, 10000));
        this.addArmorRecipes(ModItems.FIRE_ARMOR, (ItemLike)ItemsRegistry.FIRE_ESSENCE);
        this.addArmorRecipes(ModItems.WATER_ARMOR, (ItemLike)ItemsRegistry.WATER_ESSENCE);
        this.addArmorRecipes(ModItems.AIR_ARMOR, (ItemLike)ItemsRegistry.AIR_ESSENCE);
        this.addArmorRecipes(ModItems.EARTH_ARMOR, (ItemLike)ItemsRegistry.EARTH_ESSENCE);
        this.recipes.add(this.builder().withResult(new ItemStack((ItemLike)ModItems.MARK_OF_MASTERY.get(), 5)).withSourceCost(10000).withReagent((ItemLike)ItemsRegistry.WILDEN_TRIBUTE).withPedestalItem((ItemLike)ItemsRegistry.EARTH_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.FIRE_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.WATER_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.AIR_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.ABJURATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.CONJURATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)ModItems.ANIMA_ESSENCE.get()).build());
        this.recipes.add(this.builder().withResult((ItemLike)ModItems.CASTER_BAG.get()).withReagent((ItemLike)ModItems.CURIO_BAG.get()).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)Items.BLAZE_POWDER).withPedestalItem((ItemLike)Items.BLAZE_POWDER).withPedestalItem((ItemLike)Items.GOLD_BLOCK).withPedestalItem((ItemLike)Items.GOLD_BLOCK).build());
        Path output = this.generator.getPackOutput().getOutputFolder();
        for (ApparatusRecipeBuilder.RecipeWrapper g : this.recipes) {
            if (g == null) continue;
            Path path = AEApparatusProvider.getRecipePath(output, g.id().getPath());
            this.saveStable(cache, g.serialize(), path);
        }
    }

    protected void addArmorRecipes(ArmorSet armorSet, ItemLike essence) {
        this.recipes.add(this.Abuilder().withResult((ItemLike)armorSet.getHat()).withReagent(Ingredient.of(AETagsProvider.AEItemTagsProvider.MAGIC_HOOD)).withPedestalItem((ItemLike)ModItems.MARK_OF_MASTERY.get()).withPedestalItem((ItemLike)Items.NETHERITE_INGOT).withPedestalItem(2, essence).withSourceCost(7000).keepNbtOfReagent(true).build());
        this.recipes.add(this.Abuilder().withResult((ItemLike)armorSet.getChest()).withReagent(Ingredient.of(AETagsProvider.AEItemTagsProvider.MAGIC_ROBE)).withPedestalItem((ItemLike)ModItems.MARK_OF_MASTERY.get()).withPedestalItem((ItemLike)Items.NETHERITE_INGOT).withPedestalItem(2, essence).withSourceCost(7000).keepNbtOfReagent(true).build());
        this.recipes.add(this.Abuilder().withResult((ItemLike)armorSet.getLegs()).withReagent(Ingredient.of(AETagsProvider.AEItemTagsProvider.MAGIC_LEG)).withPedestalItem((ItemLike)ModItems.MARK_OF_MASTERY.get()).withPedestalItem((ItemLike)Items.NETHERITE_INGOT).withPedestalItem(2, essence).withSourceCost(7000).keepNbtOfReagent(true).build());
        this.recipes.add(this.Abuilder().withResult((ItemLike)armorSet.getBoots()).withReagent(Ingredient.of(AETagsProvider.AEItemTagsProvider.MAGIC_BOOT)).withPedestalItem((ItemLike)ModItems.MARK_OF_MASTERY.get()).withPedestalItem((ItemLike)Items.NETHERITE_INGOT).withPedestalItem(2, essence).withSourceCost(7000).keepNbtOfReagent(true).build());
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_elemental/recipe/" + str + ".json");
    }

    public String getName() {
        return "Ars Elemental Apparatus";
    }

    ArmorBuilder Abuilder() {
        return new ArmorBuilder();
    }

    public static class ArmorBuilder
    extends ApparatusRecipeBuilder {
        public ApparatusRecipeBuilder.RecipeWrapper<EnchantingApparatusRecipe> build() {
            ApparatusRecipeBuilder.RecipeWrapper wrapper = super.build();
            return new ApparatusRecipeBuilder.RecipeWrapper(wrapper.id(), (EnchantingApparatusRecipe)new ElementalArmorRecipe(wrapper.recipe().reagent(), wrapper.recipe().result(), wrapper.recipe().pedestalItems(), wrapper.recipe().sourceCost()), ElementalArmorRecipe.CODEC);
        }
    }
}

