/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.mob_effects;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LightningLureEffect
extends MobEffect {
    public LightningLureEffect() {
        super(MobEffectCategory.HARMFUL, ParticleColor.YELLOW.getColor());
    }

    public boolean applyEffectTick(@NotNull LivingEntity pLivingEntity, int pAmplifier) {
        for (int i = 0; i < pAmplifier; ++i) {
            LightningLureEffect.fallLightning(pLivingEntity);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return pDuration == 1;
    }

    public static void fallLightning(LivingEntity pLivingEntity) {
        ServerPlayer sp;
        LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(pLivingEntity.level());
        if (lightningbolt == null) {
            return;
        }
        lightningbolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pLivingEntity.blockPosition()));
        lightningbolt.setCause(pLivingEntity instanceof ServerPlayer ? (sp = (ServerPlayer)pLivingEntity) : null);
        pLivingEntity.level().addFreshEntity((Entity)lightningbolt);
    }
}

