/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.mob_effects;

import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.util.EntityCarryMEI;
import java.util.Set;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import org.jetbrains.annotations.NotNull;

public class EnthrallEffect
extends MobEffect {
    public EnthrallEffect() {
        super(MobEffectCategory.NEUTRAL, 0);
        NeoForge.EVENT_BUS.addListener(this::onTarget);
    }

    public void onTarget(LivingChangeTargetEvent event) {
        Mob thrall;
        LivingEntity livingEntity = event.getOriginalAboutToBeSetTarget();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        LivingEntity livingEntity2 = event.getEntity();
        if (livingEntity2 instanceof Mob && EnthrallEffect.isEnthralledBy((LivingEntity)(thrall = (Mob)livingEntity2), player)) {
            if (player.getLastHurtMob() != null && player.getLastHurtMob() != thrall) {
                event.setNewAboutToBeSetTarget(player.getLastHurtMob());
                if (thrall instanceof NeutralMob) {
                    angry = (NeutralMob)thrall;
                    angry.setPersistentAngerTarget(player.getLastHurtMob().getUUID());
                }
            } else if (player.getLastHurtByMob() != null && player.getLastHurtByMob() != thrall) {
                event.setNewAboutToBeSetTarget(player.getLastHurtByMob());
                if (thrall instanceof NeutralMob) {
                    angry = (NeutralMob)thrall;
                    angry.setPersistentAngerTarget(player.getLastHurtByMob().getUUID());
                }
            } else {
                event.setNewAboutToBeSetTarget(null);
                if (thrall instanceof NeutralMob) {
                    angry = (NeutralMob)thrall;
                    angry.setRemainingPersistentAngerTime(0);
                }
            }
        }
    }

    public static boolean isEnthralledBy(LivingEntity entity, Player player) {
        MobEffectInstance instance;
        if (entity.hasEffect(ModPotions.ENTHRALLED) && (instance = entity.getEffect(ModPotions.ENTHRALLED)) instanceof EntityCarryMEI) {
            EntityCarryMEI mei = (EntityCarryMEI)instance;
            return mei.getOwner() == player;
        }
        return false;
    }

    public void fillEffectCures(@NotNull Set<EffectCure> cures, @NotNull MobEffectInstance effectInstance) {
    }
}

