/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.entity.mages.AirMage;
import alexthw.ars_elemental.common.entity.mages.EarthMage;
import alexthw.ars_elemental.common.entity.mages.EntityMageBase;
import alexthw.ars_elemental.common.entity.mages.FireMage;
import alexthw.ars_elemental.common.entity.mages.WaterMage;
import alexthw.ars_elemental.common.items.foci.ElementalFocus;
import alexthw.ars_elemental.registry.ModPotions;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class Debugger
extends ElementalFocus {
    private final List<SpellSchool> elements = List.of(SpellSchools.ELEMENTAL_AIR, SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_WATER);
    private final RandomSource random = RandomSource.createNewThreadLocalInstance();

    public Debugger(Item.Properties properties) {
        super(properties, SpellSchools.NECROMANCY);
    }

    public boolean onLeftClickEntity(@NotNull ItemStack stack, Player player, @NotNull Entity entity) {
        if (player.getUUID().equals(ArsElemental.Dev) && entity instanceof Player) {
            Player target = (Player)entity;
            target.addEffect(new MobEffectInstance(ModPotions.HYMN_OF_ORDER, 6400));
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @Override
    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            EntityMageBase mage = switch (this.elements.get(this.random.nextInt(this.elements.size())).getId()) {
                case "fire" -> new FireMage((Level)level2);
                case "air" -> new AirMage((Level)level2);
                case "earth" -> new EarthMage((Level)level2);
                default -> new WaterMage((Level)level2);
            };
            mage.finalizeSpawn((ServerLevelAccessor)level2, level2.getCurrentDifficultyAt(pos), MobSpawnType.MOB_SUMMONED, null);
            mage.setPos(pContext.getClickLocation());
            level2.addFreshEntity((Entity)mage);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext context, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, context, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add(this.element.getTextComponent());
    }
}

