/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectSpark
extends ElementalAbstractEffect
implements IPotionEffect,
IDamageEffect {
    public static EffectSpark INSTANCE = new EffectSpark();

    public EffectSpark() {
        super("spark", "Spark");
    }

    public String getBookDescription() {
        return "Damages the target with a spark of static energy and shocks it. Deals more damage to wet entities";
    }

    protected int getDefaultManaCost() {
        return 15;
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity target;
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof LivingEntity && this.canDamage(shooter, spellStats, spellContext, resolver, (Entity)(target = (LivingEntity)entity))) {
            double damage = (Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier() + (double)(target.isInWaterRainOrBubble() ? 2 : 0);
            this.attemptDamage(world, shooter, spellStats, spellContext, resolver, (Entity)target, this.buildDamageSource(world, shooter), (float)damage);
            this.applyConfigPotion(target, (Holder)(ISchoolFocus.airCheck(resolver) ? ModPotions.LIGHTNING_LURE : com.hollingsworth.arsnouveau.setup.registry.ModPotions.SHOCKED_EFFECT), spellStats);
        }
    }

    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        shooter = !(shooter instanceof Player) ? ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world)) : shooter;
        return DamageUtil.source((LevelAccessor)world, ModRegistry.SPARK, (Entity)shooter);
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 3.0);
        this.addAmpConfig(builder, 1.5);
        this.addPotionConfig(builder, 15);
        this.addExtendTimeConfig(builder, 5);
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentRandomize.INSTANCE});
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_AIR});
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 15 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 5 : (Integer)this.EXTEND_TIME.get();
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }
}

