/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.registry.ModPotions;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectBubbleShield
extends ElementalAbstractEffect
implements IPotionEffect {
    public static EffectBubbleShield INSTANCE = new EffectBubbleShield();

    public EffectBubbleShield() {
        super("bubble_shield", "Bubble Shield");
    }

    public String getBookDescription() {
        return "Creates a protective coating that consumes mana to reduce incoming damage. This shielding bubble might also prevent debuff to affect the entity and will dissipate if the mana exhausts while defending. The effect will also shield from magic fire.";
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity livingEntity;
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof LivingEntity && CapabilityRegistry.getMana((LivingEntity)(livingEntity = (LivingEntity)entity)) != null) {
            this.applyConfigPotion(livingEntity, (Holder)ModPotions.MANA_BUBBLE, spellStats);
        }
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_WATER});
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    public int getDefaultManaCost() {
        return 400;
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDefaultPotionConfig(builder);
        this.addGenericInt(builder, 350, "Set how much mana is depleted every time a damage is mitigated by the Mana Bubble.", "absorption_cost");
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.getSummonAugments();
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

