/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.spells;

import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.util.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.entity.EntityLingeringSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityMagnetSpell
extends EntityLingeringSpell {
    List<Predicate<Entity>> ignored;

    public EntityMagnetSpell(EntityType<? extends EntityProjectileSpell> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityMagnetSpell(Level worldIn) {
        super((EntityType)ModEntities.LINGER_MAGNET.get(), worldIn);
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.LINGER_MAGNET.get();
    }

    public static void createMagnet(Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, Vec3 location) {
        EntityMagnetSpell magnet = new EntityMagnetSpell(world);
        magnet.ignored = EntityMagnetSpell.makeIgnores(shooter, spellContext.getSpell(), spellContext.getCurrentIndex() + 1);
        magnet.setPos(location);
        magnet.setAoe((float)spellStats.getAoeMultiplier());
        magnet.setOwner((Entity)shooter);
        magnet.extendedTime = spellStats.getDurationMultiplier();
        magnet.setColor(spellContext.getColors());
        world.addFreshEntity((Entity)magnet);
    }

    public float getAoe() {
        return super.getAoe() / 2.0f;
    }

    public void tick() {
        ++this.age;
        if (this.age > this.getExpirationTime()) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.level().isClientSide() && this.age > this.getParticleDelay()) {
            this.playParticles();
        }
        if (!this.level().isClientSide() && this.age % 5 == 0) {
            for (Entity entity : this.level().getEntities((Entity)this, new AABB(this.blockPosition()).inflate((double)this.getAoe()))) {
                Vec3 vec3d;
                if (this.testFilters(entity) || (vec3d = new Vec3(this.getX() - entity.getX(), this.getY() - entity.getY(), this.getZ() - entity.getZ())).length() < 1.0) continue;
                entity.setDeltaMovement(entity.getDeltaMovement().add(vec3d.normalize()).scale(0.5));
                entity.hurtMarked = true;
            }
        }
    }

    public boolean testFilters(Entity entity) {
        return this.ignored.stream().anyMatch(filter -> filter.test(entity));
    }

    public static List<Predicate<Entity>> makeIgnores(LivingEntity shooter, Spell spell, int index) {
        ArrayList<Predicate<Entity>> ignore = new ArrayList<Predicate<Entity>>();
        ignore.add(entity -> entity instanceof EntityLingeringSpell);
        ignore.add(entity -> entity == shooter);
        ignore.add(entity -> entity instanceof FamiliarEntity);
        ignore.add(arg_0 -> ((LivingEntity)shooter).isAlliedTo(arg_0));
        Set<IFilter> filters = GlyphEffectUtil.getFilters(spell.unsafeList(), index);
        if (!filters.isEmpty()) {
            ignore.add(entity -> GlyphEffectUtil.checkIgnoreFilters(entity, filters));
        }
        return ignore;
    }
}

