/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.ai;

import alexthw.ars_elemental.common.blocks.mermaid_block.MermaidTile;
import alexthw.ars_elemental.common.entity.MermaidEntity;
import alexthw.ars_elemental.common.entity.spells.EntityLerpedProjectile;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class MermaidChannelGoal
extends Goal {
    MermaidEntity mermaid;
    LivingEntity target;
    boolean complete;
    boolean approached;
    int timeChanneling;

    public MermaidChannelGoal(MermaidEntity drygmy) {
        this.mermaid = drygmy;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        return this.mermaid.isTamed() && this.mermaid.channelCooldown <= 0 && this.mermaid.getShrine() != null && !this.mermaid.getShrine().isOff;
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        super.start();
        MermaidTile tile = this.mermaid.getShrine();
        if (tile != null) {
            this.target = tile.getRandomEntity();
            if (this.target == null) {
                this.target = this.mermaid;
            }
            this.complete = false;
            this.approached = false;
            this.timeChanneling = 0;
        }
    }

    public boolean canContinueToUse() {
        return !this.complete && this.canUse() && this.mermaid.getShrine() != null && this.target != null && !this.target.isRemoved() && this.target.isAlive();
    }

    public void tick() {
        super.tick();
        if (!this.complete && this.target != null) {
            if (!this.approached && BlockUtil.distanceFrom((Vec3)this.mermaid.position(), (Vec3)this.target.position()) >= 2.0) {
                Path path = this.mermaid.getNavigation().createPath(this.target.getX(), this.target.getY(), this.target.getZ(), 1);
                if (path == null || !path.canReach()) {
                    this.approached = true;
                    this.mermaid.getNavigation().stop();
                    return;
                }
                this.mermaid.getNavigation().moveTo(path, 1.0);
            } else {
                this.mermaid.setChannelingEntity(this.target.getId());
                this.mermaid.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.mermaid.getMaxHeadXRot());
                this.mermaid.getNavigation().stop();
                this.approached = true;
                this.mermaid.setChanneling(true);
                ++this.timeChanneling;
                if (this.timeChanneling >= 100) {
                    this.mermaid.setChanneling(false);
                    this.mermaid.setChannelingEntity(-1);
                    this.complete = true;
                    BlockPos homePos = this.mermaid.getHome();
                    BlockPos targetPos = this.target.blockPosition();
                    if (homePos != null && homePos.getY() >= targetPos.getY() - 2) {
                        targetPos = targetPos.above(homePos.getY() - targetPos.getY());
                        EntityLerpedProjectile item = new EntityLerpedProjectile(this.mermaid.level, targetPos, homePos, 20, 100, 200);
                        this.mermaid.level.addFreshEntity((Entity)item);
                        this.mermaid.getShrine().giveProgress();
                    }
                    this.mermaid.channelCooldown = 100;
                }
            }
        }
    }

    public void stop() {
        super.stop();
        this.complete = false;
        this.approached = false;
        this.mermaid.setChannelingEntity(-1);
        this.mermaid.setChanneling(false);
        this.timeChanneling = 0;
    }
}

