/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.components;

import alexthw.ars_elemental.common.items.caster_tools.ElementalCasterTome;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellSlotMap;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class SchoolCasterTomeData
extends AbstractCaster<SchoolCasterTomeData> {
    public static final MapCodec<SchoolCasterTomeData> CODEC = SpellCaster.createCodec(SchoolCasterTomeData::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, SchoolCasterTomeData> STREAM_CODEC = SchoolCasterTomeData.createStream(SchoolCasterTomeData::new);

    public MapCodec<SchoolCasterTomeData> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, SchoolCasterTomeData> streamCodec() {
        return STREAM_CODEC;
    }

    public SchoolCasterTomeData() {
    }

    public SchoolCasterTomeData(Integer slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots) {
        super(slot, flavorText, isHidden, hiddenText, maxSlots);
    }

    public SchoolCasterTomeData(Integer slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots, SpellSlotMap spells) {
        super(slot.intValue(), flavorText, isHidden, hiddenText, maxSlots, spells);
    }

    public SpellResolver getSpellResolver(SpellContext context, Level worldIn, LivingEntity playerIn, InteractionHand handIn) {
        SpellSchool spellSchool;
        Item item = context.getCasterTool().getItem();
        if (item instanceof ElementalCasterTome) {
            ElementalCasterTome tome = (ElementalCasterTome)item;
            spellSchool = tome.getSchool();
        } else {
            spellSchool = SpellSchools.ELEMENTAL;
        }
        return new ElementalCasterTome.ETomeResolver(context, spellSchool);
    }

    public DataComponentType<SchoolCasterTomeData> getComponentType() {
        return (DataComponentType)ModRegistry.E_TOME_CASTER.get();
    }

    protected SchoolCasterTomeData build(int slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots, SpellSlotMap spells) {
        return new SchoolCasterTomeData(slot, flavorText, isHidden, hiddenText, maxSlots, spells);
    }
}

